/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.apache.hudi.org.apache.avro.Schema;

public class AvroSchemaEvolutionUtils {
    public static InternalSchema evolveSchemaFromNewAvroSchema(Schema evolvedSchema, InternalSchema oldSchema, Boolean supportPositionReorder) {
        InternalSchema evolvedInternalSchema = AvroInternalSchemaConverter.convert(evolvedSchema);
        List<String> colNamesFromEvolved = evolvedInternalSchema.getAllColsFullName();
        List<String> colNamesFromOldSchema = oldSchema.getAllColsFullName();
        List diffFromOldSchema = colNamesFromOldSchema.stream().filter(f -> !colNamesFromEvolved.contains(f)).collect(Collectors.toList());
        ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
        if (colNamesFromEvolved.size() == colNamesFromOldSchema.size() && diffFromOldSchema.size() == 0) {
            if (supportPositionReorder.booleanValue()) {
                evolvedInternalSchema.getRecord().fields().forEach(f -> newFields.add(oldSchema.getRecord().field(f.name())));
                return new InternalSchema(newFields);
            }
            return oldSchema;
        }
        if (diffFromOldSchema.size() != 0) {
            throw new UnsupportedOperationException("Cannot evolve schema implicitly, find delete/rename operation");
        }
        List diffFromEvolutionSchema = colNamesFromEvolved.stream().filter(f -> !colNamesFromOldSchema.contains(f)).collect(Collectors.toList());
        TreeMap<Integer, String> finalAddAction = new TreeMap<Integer, String>();
        for (int i = 0; i < diffFromEvolutionSchema.size(); ++i) {
            String parentName;
            String name = (String)diffFromEvolutionSchema.get(i);
            int splitPoint = name.lastIndexOf(".");
            String string = parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            if (!parentName.isEmpty() && diffFromEvolutionSchema.contains(parentName)) continue;
            finalAddAction.put(evolvedInternalSchema.findIdByName(name), name);
        }
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldSchema);
        finalAddAction.entrySet().stream().forEach(f -> {
            String name = (String)f.getValue();
            int splitPoint = name.lastIndexOf(".");
            String parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            String rawName = splitPoint > 0 ? name.substring(splitPoint + 1) : name;
            addChange.addColumns(parentName, rawName, evolvedInternalSchema.findType(name), null);
        });
        InternalSchema res = SchemaChangeUtils.applyTableChanges2Schema(oldSchema, addChange);
        if (supportPositionReorder.booleanValue()) {
            evolvedInternalSchema.getRecord().fields().forEach(f -> newFields.add(oldSchema.getRecord().field(f.name())));
            return new InternalSchema(newFields);
        }
        return res;
    }

    public static InternalSchema evolveSchemaFromNewAvroSchema(Schema evolvedSchema, InternalSchema oldSchema) {
        return AvroSchemaEvolutionUtils.evolveSchemaFromNewAvroSchema(evolvedSchema, oldSchema, false);
    }

    public static Schema canonicalizeColumnNullability(Schema writeSchema, Schema readSchema) {
        if (writeSchema.getFields().isEmpty() || readSchema.getFields().isEmpty()) {
            return writeSchema;
        }
        InternalSchema writeInternalSchema = AvroInternalSchemaConverter.convert(writeSchema);
        InternalSchema readInternalSchema = AvroInternalSchemaConverter.convert(readSchema);
        List<String> colNamesWriteSchema = writeInternalSchema.getAllColsFullName();
        List<String> colNamesFromReadSchema = readInternalSchema.getAllColsFullName();
        List candidateUpdateCols = colNamesWriteSchema.stream().filter(f -> {
            boolean exist = colNamesFromReadSchema.contains(f);
            return exist && writeInternalSchema.findField((String)f).isOptional() != readInternalSchema.findField((String)f).isOptional();
        }).collect(Collectors.toList());
        if (candidateUpdateCols.isEmpty()) {
            return writeSchema;
        }
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(writeInternalSchema);
        candidateUpdateCols.stream().forEach(f -> updateChange.updateColumnNullability((String)f, true));
        Schema result = AvroInternalSchemaConverter.convert(SchemaChangeUtils.applyTableChanges2Schema(writeInternalSchema, updateChange), writeSchema.getName());
        return result;
    }
}

