/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.column.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hudi.org.apache.parquet.column.ColumnDescriptor;
import org.apache.hudi.org.apache.parquet.column.ColumnWriteStore;
import org.apache.hudi.org.apache.parquet.column.ColumnWriter;
import org.apache.hudi.org.apache.parquet.column.ParquetProperties;
import org.apache.hudi.org.apache.parquet.column.impl.ColumnWriterV2;
import org.apache.hudi.org.apache.parquet.column.page.PageWriteStore;
import org.apache.hudi.org.apache.parquet.column.page.PageWriter;
import org.apache.hudi.org.apache.parquet.schema.MessageType;

public class ColumnWriteStoreV2
implements ColumnWriteStore {
    private static final float THRESHOLD_TOLERANCE_RATIO = 0.1f;
    private final Map<ColumnDescriptor, ColumnWriterV2> columns;
    private final Collection<ColumnWriterV2> writers;
    private final ParquetProperties props;
    private final long thresholdTolerance;
    private long rowCount;
    private long rowCountForNextSizeCheck;

    public ColumnWriteStoreV2(MessageType schema, PageWriteStore pageWriteStore, ParquetProperties props) {
        this.props = props;
        this.thresholdTolerance = (long)((float)props.getPageSizeThreshold() * 0.1f);
        TreeMap<ColumnDescriptor, ColumnWriterV2> mcolumns = new TreeMap<ColumnDescriptor, ColumnWriterV2>();
        for (ColumnDescriptor path : schema.getColumns()) {
            PageWriter pageWriter = pageWriteStore.getPageWriter(path);
            mcolumns.put(path, new ColumnWriterV2(path, pageWriter, props));
        }
        this.columns = Collections.unmodifiableMap(mcolumns);
        this.writers = this.columns.values();
        this.rowCountForNextSizeCheck = props.getMinRowCountForPageSizeCheck();
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        return this.columns.get(path);
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterV2> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getTotalBufferedSize()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        long total = 0L;
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    @Override
    public long getBufferedSize() {
        long total = 0L;
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            total += memColumn.getTotalBufferedSize();
        }
        return total;
    }

    @Override
    public void flush() {
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            long rows = this.rowCount - memColumn.getRowsWrittenSoFar();
            if (rows > 0L) {
                memColumn.writePage(this.rowCount);
            }
            memColumn.finalizeColumnChunk();
        }
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    @Override
    public void close() {
        this.flush();
        for (ColumnWriterV2 memColumn : this.columns.values()) {
            memColumn.close();
        }
    }

    @Override
    public void endRecord() {
        ++this.rowCount;
        if (this.rowCount >= this.rowCountForNextSizeCheck) {
            this.sizeCheck();
        }
    }

    private void sizeCheck() {
        long minRecordToWait = Long.MAX_VALUE;
        for (ColumnWriterV2 writer : this.writers) {
            long rowsToFillPage;
            long usedMem = writer.getCurrentPageBufferedSize();
            long rows = this.rowCount - writer.getRowsWrittenSoFar();
            long remainingMem = (long)this.props.getPageSizeThreshold() - usedMem;
            if (remainingMem <= this.thresholdTolerance) {
                writer.writePage(this.rowCount);
                remainingMem = this.props.getPageSizeThreshold();
            }
            if ((rowsToFillPage = usedMem == 0L ? (long)this.props.getMaxRowCountForPageSizeCheck() : (long)((float)rows) / usedMem * remainingMem) >= minRecordToWait) continue;
            minRecordToWait = rowsToFillPage;
        }
        if (minRecordToWait == Long.MAX_VALUE) {
            minRecordToWait = this.props.getMinRowCountForPageSizeCheck();
        }
        this.rowCountForNextSizeCheck = this.props.estimateNextSizeCheck() ? this.rowCount + Math.min(Math.max(minRecordToWait / 2L, (long)this.props.getMinRowCountForPageSizeCheck()), (long)this.props.getMaxRowCountForPageSizeCheck()) : this.rowCount + (long)this.props.getMinRowCountForPageSizeCheck();
    }
}

