/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.io;

import java.util.Arrays;
import org.apache.hudi.org.apache.parquet.io.api.Binary;
import org.apache.hudi.org.apache.parquet.io.api.RecordConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordConsumerLoggingWrapper
extends RecordConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(RecordConsumerLoggingWrapper.class);
    private final RecordConsumer delegate;
    int indent = 0;

    public RecordConsumerLoggingWrapper(RecordConsumer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void startField(String field, int index) {
        this.logOpen(field);
        this.delegate.startField(field, index);
    }

    private void logOpen(String field) {
        this.log("<{}>", field);
    }

    private String indent() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    private void log(Object value, Object ... parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.indent() + value, parameters);
        }
    }

    @Override
    public void startGroup() {
        ++this.indent;
        this.log("<!-- start group -->", new Object[0]);
        this.delegate.startGroup();
    }

    @Override
    public void addInteger(int value) {
        this.log(value, new Object[0]);
        this.delegate.addInteger(value);
    }

    @Override
    public void addLong(long value) {
        this.log(value, new Object[0]);
        this.delegate.addLong(value);
    }

    @Override
    public void addBoolean(boolean value) {
        this.log(value, new Object[0]);
        this.delegate.addBoolean(value);
    }

    @Override
    public void addBinary(Binary value) {
        if (LOG.isDebugEnabled()) {
            this.log(Arrays.toString(value.getBytesUnsafe()), new Object[0]);
        }
        this.delegate.addBinary(value);
    }

    @Override
    public void addFloat(float value) {
        this.log(Float.valueOf(value), new Object[0]);
        this.delegate.addFloat(value);
    }

    @Override
    public void addDouble(double value) {
        this.log(value, new Object[0]);
        this.delegate.addDouble(value);
    }

    @Override
    public void flush() {
        this.log("<!-- flush -->", new Object[0]);
        this.delegate.flush();
    }

    @Override
    public void endGroup() {
        this.log("<!-- end group -->", new Object[0]);
        --this.indent;
        this.delegate.endGroup();
    }

    @Override
    public void endField(String field, int index) {
        this.logClose(field);
        this.delegate.endField(field, index);
    }

    private void logClose(String field) {
        this.log("</{}>", field);
    }

    @Override
    public void startMessage() {
        this.log("<!-- start message -->", new Object[0]);
        this.delegate.startMessage();
    }

    @Override
    public void endMessage() {
        this.delegate.endMessage();
        this.log("<!-- end message -->", new Object[0]);
    }
}

