/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetReader;

public class ParquetReaderIterator<T>
implements ClosableIterator<T> {
    private final ParquetReader<T> parquetReader;
    private T next;

    public ParquetReaderIterator(ParquetReader<T> parquetReader) {
        this.parquetReader = parquetReader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.next == null) {
                this.next = this.parquetReader.read();
            }
            return this.next != null;
        }
        catch (Exception e) {
            FileIOUtils.closeQuietly(this.parquetReader);
            throw new HoodieException("unable to read next record from parquet file ", e);
        }
    }

    @Override
    public T next() {
        try {
            if (this.next == null && !this.hasNext()) {
                throw new HoodieException("No more records left to read from parquet file");
            }
            T retVal = this.next;
            this.next = this.parquetReader.read();
            return retVal;
        }
        catch (Exception e) {
            FileIOUtils.closeQuietly(this.parquetReader);
            throw new HoodieException("unable to read next record from parquet file ", e);
        }
    }

    @Override
    public void close() {
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new HoodieException("Exception while closing the parquet reader", e);
        }
    }
}

