/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.io.storage.HoodieOrcReader;
import org.apache.hudi.io.storage.HoodieParquetReader;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;

public class HoodieFileReaderFactory {
    public static <R extends IndexedRecord> HoodieFileReader<R> getFileReader(Configuration conf, Path path) throws IOException {
        String extension = FSUtils.getFileExtension(path.toString());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieFileReaderFactory.newParquetFileReader(conf, path);
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return HoodieFileReaderFactory.newHFileFileReader(conf, path);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return HoodieFileReaderFactory.newOrcFileReader(conf, path);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static <R extends IndexedRecord> HoodieFileReader<R> newParquetFileReader(Configuration conf, Path path) {
        return new HoodieParquetReader(conf, path);
    }

    private static <R extends IndexedRecord> HoodieFileReader<R> newHFileFileReader(Configuration conf, Path path) throws IOException {
        CacheConfig cacheConfig = new CacheConfig(conf);
        return new HoodieHFileReader(conf, path, cacheConfig);
    }

    private static <R extends IndexedRecord> HoodieFileReader<R> newOrcFileReader(Configuration conf, Path path) {
        return new HoodieOrcReader(conf, path);
    }
}

