/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Locale;
import java.util.Properties;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class KeyStoreKeyProvider
implements KeyProvider {
    protected KeyStore store;
    protected char[] password;
    protected Properties passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processParameter(String name, String value) throws IOException {
        if (name.equalsIgnoreCase("password")) {
            this.password = value.toCharArray();
        }
        if (name.equalsIgnoreCase("passwordfile")) {
            Properties p = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(value)));){
                p.load(in);
                this.passwordFile = p;
            }
        }
    }

    protected void processParameters(URI uri) throws IOException {
        int valueEnd;
        String params = uri.getQuery();
        if (params == null || params.isEmpty()) {
            return;
        }
        do {
            int nameStart = 0;
            int nameEnd = params.indexOf(61);
            if (nameEnd == -1) {
                throw new RuntimeException("Invalid parameters: '" + params + "'");
            }
            int valueStart = nameEnd + 1;
            valueEnd = params.indexOf(38);
            if (valueEnd == -1) {
                valueEnd = params.length();
            }
            String name = URLDecoder.decode(params.substring(nameStart, nameEnd), "UTF-8");
            String value = URLDecoder.decode(params.substring(valueStart, valueEnd), "UTF-8");
            this.processParameter(name, value);
        } while (!(params = params.substring(valueEnd, params.length())).isEmpty());
    }

    protected void load(URI uri) throws IOException {
        String path = uri.getPath();
        if (path == null || path.isEmpty()) {
            throw new RuntimeException("KeyProvider parameters should specify a path");
        }
        try (FileInputStream is = new FileInputStream(new File(path));){
            this.store.load(is, this.password);
        }
    }

    @Override
    public void init(String params) {
        try {
            URI uri = new URI(params);
            String storeType = uri.getScheme();
            if (storeType == null || storeType.isEmpty()) {
                throw new RuntimeException("KeyProvider scheme should specify KeyStore type");
            }
            this.store = KeyStore.getInstance(storeType.toUpperCase(Locale.ROOT));
            this.processParameters(uri);
            this.load(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected char[] getAliasPassword(String alias) {
        String p;
        if (this.password != null) {
            return this.password;
        }
        if (this.passwordFile != null && (p = this.passwordFile.getProperty(alias)) != null) {
            return p.toCharArray();
        }
        return null;
    }

    @Override
    public Key getKey(String alias) {
        try {
            return this.store.getKey(alias, this.getAliasPassword(alias));
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Key[] getKeys(String[] aliases) {
        Key[] result = new Key[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            result[i] = this.getKey(aliases[i]);
        }
        return result;
    }
}

