/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RpcClientFactory {
    public static final String CUSTOM_RPC_CLIENT_IMPL_CONF_KEY = "hbase.rpc.client.impl";
    private static final ImmutableMap<String, String> DEPRECATED_NAME_MAPPING = ImmutableMap.of("org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClientImpl", BlockingRpcClient.class.getName(), "org.apache.hudi.org.apache.hadoop.hbase.ipc.AsyncRpcClient", NettyRpcClient.class.getName());

    private RpcClientFactory() {
    }

    public static RpcClient createClient(Configuration conf, String clusterId) {
        return RpcClientFactory.createClient(conf, clusterId, null);
    }

    public static RpcClient createClient(Configuration conf, String clusterId, MetricsConnection metrics) {
        return RpcClientFactory.createClient(conf, clusterId, null, metrics);
    }

    private static String getRpcClientClass(Configuration conf) {
        String rpcClientClass = conf.get(CUSTOM_RPC_CLIENT_IMPL_CONF_KEY);
        if (rpcClientClass == null) {
            return NettyRpcClient.class.getName();
        }
        String mappedName = DEPRECATED_NAME_MAPPING.get(rpcClientClass);
        return mappedName == null ? rpcClientClass : mappedName;
    }

    public static RpcClient createClient(Configuration conf, String clusterId, SocketAddress localAddr, MetricsConnection metrics) {
        String rpcClientClass = RpcClientFactory.getRpcClientClass(conf);
        return (RpcClient)ReflectionUtils.instantiateWithCustomCtor(rpcClientClass, new Class[]{Configuration.class, String.class, SocketAddress.class, MetricsConnection.class}, new Object[]{conf, clusterId, localAddr, metrics});
    }
}

