/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.TagUtil;
import org.apache.hudi.org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobConstants;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hudi.org.apache.hadoop.hbase.mob.compactions.MobCompactor;
import org.apache.hudi.org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactionRequest;
import org.apache.hudi.org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MobUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MobUtils.class);
    private static final long WEEKLY_THRESHOLD_MULTIPLIER = 7L;
    private static final long MONTHLY_THRESHOLD_MULTIPLIER = 28L;
    private static final ThreadLocal<SimpleDateFormat> LOCAL_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    private static final byte[] REF_DELETE_MARKER_TAG_BYTES;

    private MobUtils() {
    }

    public static String formatDate(Date date) {
        return LOCAL_FORMAT.get().format(date);
    }

    public static Date parseDate(String dateString) throws ParseException {
        return LOCAL_FORMAT.get().parse(dateString);
    }

    public static Date getFirstDayOfMonth(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        Date firstDayInMonth = calendar.getTime();
        return firstDayInMonth;
    }

    public static Date getFirstDayOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, 2);
        Date firstDayInWeek = calendar.getTime();
        return firstDayInWeek;
    }

    public static boolean isMobReferenceCell(Cell cell) {
        Optional<Tag> tag;
        return cell.getTagsLength() > 0 && (tag = PrivateCellUtil.getTag(cell, (byte)5)).isPresent();
    }

    public static Tag getTableNameTag(Cell cell) {
        Optional<Tag> tag;
        if (cell.getTagsLength() > 0 && (tag = PrivateCellUtil.getTag(cell, (byte)6)).isPresent()) {
            return tag.get();
        }
        return null;
    }

    public static boolean hasMobReferenceTag(List<Tag> tags) {
        if (!tags.isEmpty()) {
            for (Tag tag : tags) {
                if (tag.getType() != 5) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRawMobScan(Scan scan) {
        byte[] raw = scan.getAttribute("hbase.mob.scan.raw");
        try {
            return raw != null && Bytes.toBoolean(raw);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isRefOnlyScan(Scan scan) {
        byte[] refOnly = scan.getAttribute("hbase.mob.scan.ref.only");
        try {
            return refOnly != null && Bytes.toBoolean(refOnly);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isCacheMobBlocks(Scan scan) {
        byte[] cache = scan.getAttribute("hbase.mob.cache.blocks");
        try {
            return cache != null && Bytes.toBoolean(cache);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void setCacheMobBlocks(Scan scan, boolean cacheBlocks) {
        scan.setAttribute("hbase.mob.cache.blocks", Bytes.toBytes(cacheBlocks));
    }

    public static void cleanExpiredMobFiles(FileSystem fs, Configuration conf, TableName tableName, ColumnFamilyDescriptor columnDescriptor, CacheConfig cacheConfig, long current) throws IOException {
        long timeToLive = columnDescriptor.getTimeToLive();
        if (Integer.MAX_VALUE == timeToLive) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(current - timeToLive * 1000L);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date expireDate = calendar.getTime();
        LOG.info("MOB HFiles older than " + expireDate.toGMTString() + " will be deleted!");
        FileStatus[] stats = null;
        Path mobTableDir = CommonFSUtils.getTableDir(MobUtils.getMobHome(conf), tableName);
        Path path = MobUtils.getMobFamilyPath(conf, tableName, columnDescriptor.getNameAsString());
        try {
            stats = fs.listStatus(path);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Failed to find the mob file " + path, (Throwable)e);
        }
        if (null == stats) {
            return;
        }
        ArrayList<HStoreFile> filesToClean = new ArrayList<HStoreFile>();
        int deletedFileCount = 0;
        for (FileStatus file : stats) {
            String fileName = file.getPath().getName();
            try {
                if (HFileLink.isHFileLink(file.getPath())) {
                    HFileLink hfileLink = HFileLink.buildFromHFileLinkPattern(conf, file.getPath());
                    fileName = hfileLink.getOriginPath().getName();
                }
                Date fileDate = MobUtils.parseDate(MobFileName.getDateFromName(fileName));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking file " + fileName);
                }
                if (fileDate.getTime() >= expireDate.getTime()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(fileName + " is an expired file");
                }
                filesToClean.add(new HStoreFile(fs, file.getPath(), conf, cacheConfig, BloomType.NONE, true));
            }
            catch (Exception e) {
                LOG.error("Cannot parse the fileName " + fileName, (Throwable)e);
            }
        }
        if (!filesToClean.isEmpty()) {
            try {
                MobUtils.removeMobFiles(conf, fs, tableName, mobTableDir, columnDescriptor.getName(), filesToClean);
                deletedFileCount = filesToClean.size();
            }
            catch (IOException e) {
                LOG.error("Failed to delete the mob files " + filesToClean, (Throwable)e);
            }
        }
        LOG.info(deletedFileCount + " expired mob files are deleted");
    }

    public static Path getMobHome(Configuration conf) {
        Path hbaseDir = new Path(conf.get("hbase.rootdir"));
        return MobUtils.getMobHome(hbaseDir);
    }

    public static Path getMobHome(Path rootDir) {
        return new Path(rootDir, "mobdir");
    }

    public static Path getQualifiedMobRootDir(Configuration conf) throws IOException {
        Path hbaseDir = new Path(conf.get("hbase.rootdir"));
        Path mobRootDir = new Path(hbaseDir, "mobdir");
        FileSystem fs = mobRootDir.getFileSystem(conf);
        return mobRootDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public static Path getMobTableDir(Path rootDir, TableName tableName) {
        return CommonFSUtils.getTableDir(MobUtils.getMobHome(rootDir), tableName);
    }

    public static Path getMobRegionPath(Configuration conf, TableName tableName) {
        return MobUtils.getMobRegionPath(new Path(conf.get("hbase.rootdir")), tableName);
    }

    public static Path getMobRegionPath(Path rootDir, TableName tableName) {
        Path tablePath = CommonFSUtils.getTableDir(MobUtils.getMobHome(rootDir), tableName);
        RegionInfo regionInfo = MobUtils.getMobRegionInfo(tableName);
        return new Path(tablePath, regionInfo.getEncodedName());
    }

    public static Path getMobFamilyPath(Configuration conf, TableName tableName, String familyName) {
        return new Path(MobUtils.getMobRegionPath(conf, tableName), familyName);
    }

    public static Path getMobFamilyPath(Path regionPath, String familyName) {
        return new Path(regionPath, familyName);
    }

    public static RegionInfo getMobRegionInfo(TableName tableName) {
        return RegionInfoBuilder.newBuilder(tableName).setStartKey(MobConstants.MOB_REGION_NAME_BYTES).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(0L).build();
    }

    public static boolean isMobRegionInfo(RegionInfo regionInfo) {
        return regionInfo == null ? false : MobUtils.getMobRegionInfo(regionInfo.getTable()).getEncodedName().equals(regionInfo.getEncodedName());
    }

    public static boolean isMobRegionName(TableName tableName, byte[] regionName) {
        return Bytes.equals(regionName, MobUtils.getMobRegionInfo(tableName).getRegionName());
    }

    public static Path getCompactionWorkingPath(Path root, String jobName) {
        return new Path(root, jobName);
    }

    public static void removeMobFiles(Configuration conf, FileSystem fs, TableName tableName, Path tableDir, byte[] family, Collection<HStoreFile> storeFiles) throws IOException {
        HFileArchiver.archiveStoreFiles(conf, fs, MobUtils.getMobRegionInfo(tableName), tableDir, family, storeFiles);
    }

    public static Cell createMobRefCell(Cell cell, byte[] fileName, Tag tableNameTag) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(MobConstants.MOB_REF_TAG);
        tags.add(tableNameTag);
        return MobUtils.createMobRefCell(cell, fileName, TagUtil.fromList(tags));
    }

    public static Cell createMobRefCell(Cell cell, byte[] fileName, byte[] refCellTags) {
        byte[] refValue = Bytes.add(Bytes.toBytes(cell.getValueLength()), fileName);
        return PrivateCellUtil.createCell(cell, refValue, TagUtil.concatTags(refCellTags, cell));
    }

    public static StoreFileWriter createWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, String startKey, CacheConfig cacheConfig, Encryption.Context cryptoContext, boolean isCompaction) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig, cryptoContext, isCompaction);
    }

    public static StoreFileWriter createRefFileWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, Path basePath, long maxKeyCount, CacheConfig cacheConfig, Encryption.Context cryptoContext, boolean isCompaction) throws IOException {
        return MobUtils.createWriter(conf, fs, family, new Path(basePath, UUID.randomUUID().toString().replaceAll("-", "")), maxKeyCount, family.getCompactionCompressionType(), cacheConfig, cryptoContext, StoreUtils.getChecksumType(conf), StoreUtils.getBytesPerChecksum(conf), family.getBlocksize(), family.getBloomFilterType(), isCompaction);
    }

    public static StoreFileWriter createWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, CacheConfig cacheConfig, Encryption.Context cryptoContext, boolean isCompaction) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig, cryptoContext, isCompaction);
    }

    public static StoreFileWriter createDelFileWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, CacheConfig cacheConfig, Encryption.Context cryptoContext) throws IOException {
        String suffix = UUID.randomUUID().toString().replaceAll("-", "") + "_del";
        MobFileName mobFileName = MobFileName.create(startKey, date, suffix);
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig, cryptoContext, true);
    }

    public static StoreFileWriter createWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, MobFileName mobFileName, Path basePath, long maxKeyCount, Compression.Algorithm compression, CacheConfig cacheConfig, Encryption.Context cryptoContext, boolean isCompaction) throws IOException {
        return MobUtils.createWriter(conf, fs, family, new Path(basePath, mobFileName.getFileName()), maxKeyCount, compression, cacheConfig, cryptoContext, StoreUtils.getChecksumType(conf), StoreUtils.getBytesPerChecksum(conf), family.getBlocksize(), BloomType.NONE, isCompaction);
    }

    public static StoreFileWriter createWriter(Configuration conf, FileSystem fs, ColumnFamilyDescriptor family, Path path, long maxKeyCount, Compression.Algorithm compression, CacheConfig cacheConfig, Encryption.Context cryptoContext, ChecksumType checksumType, int bytesPerChecksum, int blocksize, BloomType bloomType, boolean isCompaction) throws IOException {
        CacheConfig writerCacheConf;
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        if (isCompaction) {
            writerCacheConf = new CacheConfig(cacheConfig);
            writerCacheConf.setCacheDataOnWrite(false);
        } else {
            writerCacheConf = cacheConfig;
        }
        HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withIncludesMvcc(true).withIncludesTags(true).withCompressTags(family.isCompressTags()).withChecksumType(checksumType).withBytesPerCheckSum(bytesPerChecksum).withBlockSize(blocksize).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(cryptoContext).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        StoreFileWriter w = new StoreFileWriter.Builder(conf, writerCacheConf, fs).withFilePath(path).withBloomType(bloomType).withMaxKeyCount(maxKeyCount).withFileContext(hFileContext).build();
        return w;
    }

    public static Path commitFile(Configuration conf, FileSystem fs, Path sourceFile, Path targetPath, CacheConfig cacheConfig) throws IOException {
        if (sourceFile == null) {
            return null;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        MobUtils.validateMobFile(conf, fs, sourceFile, cacheConfig, true);
        String msg = "Renaming flushed file from " + sourceFile + " to " + dstPath;
        LOG.info(msg);
        Path parent = dstPath.getParent();
        if (!fs.exists(parent)) {
            fs.mkdirs(parent);
        }
        if (!fs.rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
        return dstPath;
    }

    private static void validateMobFile(Configuration conf, FileSystem fs, Path path, CacheConfig cacheConfig, boolean primaryReplica) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = new HStoreFile(fs, path, conf, cacheConfig, BloomType.NONE, primaryReplica);
            storeFile.initReader();
        }
        catch (IOException e) {
            LOG.error("Failed to open mob file[" + path + "], keep it in temp directory.", (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    public static boolean hasValidMobRefCellValue(Cell cell) {
        return cell.getValueLength() > 4;
    }

    public static int getMobValueLength(Cell cell) {
        return PrivateCellUtil.getValueAsInt(cell);
    }

    public static String getMobFileName(Cell cell) {
        return Bytes.toString(cell.getValueArray(), cell.getValueOffset() + 4, cell.getValueLength() - 4);
    }

    public static TableName getTableLockName(TableName tn) {
        byte[] tableName = tn.getName();
        return TableName.valueOf(Bytes.add(tableName, MobConstants.MOB_TABLE_LOCK_SUFFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMobCompaction(Configuration conf, FileSystem fs, TableName tableName, ColumnFamilyDescriptor hcd, ExecutorService pool, boolean allFiles, LockManager.MasterLock lock) throws IOException {
        String className = conf.get("hbase.mob.compactor.class", PartitionedMobCompactor.class.getName());
        MobCompactor compactor = null;
        try {
            compactor = (MobCompactor)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, FileSystem.class, TableName.class, ColumnFamilyDescriptor.class, ExecutorService.class}, new Object[]{conf, fs, tableName, hcd, pool});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured mob file compactor '" + className + "'", e);
        }
        try {
            lock.acquire();
            LOG.info("start MOB compaction of files for table='{}', column='{}', allFiles={}, compactor='{}'", new Object[]{tableName, hcd.getNameAsString(), allFiles, compactor.getClass()});
            compactor.compact(allFiles);
        }
        catch (Exception e) {
            try {
                LOG.error("Failed to compact the mob files for the column " + hcd.getNameAsString() + " in the table " + tableName.getNameAsString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LOG.info("end MOB compaction of files for table='{}', column='{}', allFiles={}, compactor='{}'", new Object[]{tableName, hcd.getNameAsString(), allFiles, compactor.getClass()});
                lock.release();
                throw throwable;
            }
            LOG.info("end MOB compaction of files for table='{}', column='{}', allFiles={}, compactor='{}'", new Object[]{tableName, hcd.getNameAsString(), allFiles, compactor.getClass()});
            lock.release();
        }
        LOG.info("end MOB compaction of files for table='{}', column='{}', allFiles={}, compactor='{}'", new Object[]{tableName, hcd.getNameAsString(), allFiles, compactor.getClass()});
        lock.release();
    }

    public static ExecutorService createMobCompactorThreadPool(Configuration conf) {
        int maxThreads = conf.getInt("hbase.mob.compaction.threads.max", 1);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, 60L, TimeUnit.SECONDS, queue, new ThreadFactoryBuilder().setNameFormat("MobCompactor-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), (r, executor) -> {
            try {
                queue.put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static boolean hasMobColumns(TableDescriptor htd) {
        ColumnFamilyDescriptor[] hcds;
        for (ColumnFamilyDescriptor hcd : hcds = htd.getColumnFamilies()) {
            if (!hcd.isMobEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadEmptyValueOnMobCellMiss(Scan scan) {
        byte[] readEmptyValueOnMobCellMiss = scan.getAttribute("empty.value.on.mobcell.miss");
        try {
            return readEmptyValueOnMobCellMiss != null && Bytes.toBoolean(readEmptyValueOnMobCellMiss);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Cell createMobRefDeleteMarker(Cell cell) {
        return PrivateCellUtil.createCell(cell, TagUtil.concatTags(REF_DELETE_MARKER_TAG_BYTES, cell));
    }

    public static boolean isMobFileExpired(ColumnFamilyDescriptor column, long current, String fileDate) {
        if (column.getMinVersions() > 0) {
            return false;
        }
        long timeToLive = column.getTimeToLive();
        if (Integer.MAX_VALUE == timeToLive) {
            return false;
        }
        Date expireDate = new Date(current - timeToLive * 1000L);
        expireDate = new Date(expireDate.getYear(), expireDate.getMonth(), expireDate.getDate());
        try {
            Date date = MobUtils.parseDate(fileDate);
            if (date.getTime() < expireDate.getTime()) {
                return true;
            }
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse the date " + fileDate, (Throwable)e);
            return false;
        }
        return false;
    }

    public static boolean fillPartitionId(PartitionedMobCompactionRequest.CompactionPartitionId id, Date firstDayOfCurrentMonth, Date firstDayOfCurrentWeek, String dateStr, MobCompactPartitionPolicy policy, Calendar calendar, long threshold) {
        Date date;
        boolean skipCompcation = false;
        id.setThreshold(threshold);
        if (threshold <= 0L) {
            id.setDate(dateStr);
            return skipCompcation;
        }
        try {
            date = MobUtils.parseDate(dateStr);
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse date " + dateStr, (Throwable)e);
            id.setDate(dateStr);
            return true;
        }
        if (policy == MobCompactPartitionPolicy.MONTHLY && date.before(firstDayOfCurrentMonth)) {
            long finalThreshold = threshold < 0x492492492492492L ? 28L * threshold : Long.MAX_VALUE;
            id.setThreshold(finalThreshold);
            id.setDate(MobUtils.formatDate(MobUtils.getFirstDayOfMonth(calendar, date)));
            return skipCompcation;
        }
        if (policy == MobCompactPartitionPolicy.MONTHLY || policy == MobCompactPartitionPolicy.WEEKLY) {
            if (date.before(firstDayOfCurrentWeek)) {
                long finalThreshold = threshold < 1317624576693539401L ? 7L * threshold : Long.MAX_VALUE;
                id.setThreshold(finalThreshold);
                id.setDate(MobUtils.formatDate(MobUtils.getFirstDayOfWeek(calendar, date)));
                return skipCompcation;
            }
            if (policy == MobCompactPartitionPolicy.MONTHLY) {
                skipCompcation = true;
            }
        }
        id.setDate(dateStr);
        return skipCompcation;
    }

    static {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(MobConstants.MOB_REF_TAG);
        REF_DELETE_MARKER_TAG_BYTES = TagUtil.fromList(tags);
    }
}

