/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.EightBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.EightBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.FiveBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.FiveBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.FourBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.FourBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.OneBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.OneBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.SevenBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.SevenBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.SixBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.SixBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.ThreeBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.ThreeBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.TwoBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.TwoBitPackingWriter;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.ZeroBitPackingReader;
import org.apache.hudi.org.apache.parquet.column.values.bitpacking.ZeroBitPackingWriter;

public class BitPacking {
    private BitPacking() {
    }

    public static BitPackingWriter getBitPackingWriter(int bitLength, OutputStream out) {
        switch (bitLength) {
            case 0: {
                return new ZeroBitPackingWriter();
            }
            case 1: {
                return new OneBitPackingWriter(out);
            }
            case 2: {
                return new TwoBitPackingWriter(out);
            }
            case 3: {
                return new ThreeBitPackingWriter(out);
            }
            case 4: {
                return new FourBitPackingWriter(out);
            }
            case 5: {
                return new FiveBitPackingWriter(out);
            }
            case 6: {
                return new SixBitPackingWriter(out);
            }
            case 7: {
                return new SevenBitPackingWriter(out);
            }
            case 8: {
                return new EightBitPackingWriter(out);
            }
        }
        throw new UnsupportedOperationException("only support up to 8 for now");
    }

    public static BitPackingReader createBitPackingReader(int bitLength, InputStream in, long valueCount) {
        switch (bitLength) {
            case 0: {
                return new ZeroBitPackingReader();
            }
            case 1: {
                return new OneBitPackingReader(in);
            }
            case 2: {
                return new TwoBitPackingReader(in);
            }
            case 3: {
                return new ThreeBitPackingReader(in, valueCount);
            }
            case 4: {
                return new FourBitPackingReader(in);
            }
            case 5: {
                return new FiveBitPackingReader(in, valueCount);
            }
            case 6: {
                return new SixBitPackingReader(in, valueCount);
            }
            case 7: {
                return new SevenBitPackingReader(in, valueCount);
            }
            case 8: {
                return new EightBitPackingReader(in);
            }
        }
        throw new UnsupportedOperationException("only support up to 8 for now");
    }

    public static abstract class BitPackingReader {
        public abstract int read() throws IOException;
    }

    public static abstract class BitPackingWriter {
        public abstract void write(int var1) throws IOException;

        public abstract void finish() throws IOException;
    }
}

