/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.parquet.column.ParquetProperties;
import org.apache.hudi.org.apache.parquet.hadoop.CodecFactory;
import org.apache.hudi.org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.hudi.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.hudi.org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.hudi.org.apache.parquet.io.OutputFile;
import org.apache.hudi.org.apache.parquet.schema.MessageType;

public class ParquetWriter<T>
implements Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 0x8000000;
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final CompressionCodecName DEFAULT_COMPRESSION_CODEC_NAME = CompressionCodecName.UNCOMPRESSED;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.DEFAULT_WRITER_VERSION;
    public static final String OBJECT_MODEL_NAME_PROP = "writer.model.name";
    public static final int MAX_PADDING_SIZE_DEFAULT = 0x800000;
    private final InternalParquetRecordWriter<T> writer;
    private final CodecFactory codecFactory;

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, true, false);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, validating);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, DEFAULT_WRITER_VERSION);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, new Configuration());
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(file, ParquetFileWriter.Mode.CREATE, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, conf);
    }

    @Deprecated
    public ParquetWriter(Path file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(HadoopOutputFile.fromPath(file, conf), mode, writeSupport, compressionCodecName, blockSize, validating, conf, 0x800000, ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build());
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000);
    }

    @Deprecated
    public ParquetWriter(Path file, Configuration conf, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000, 0x100000, true, false, DEFAULT_WRITER_VERSION, conf);
    }

    ParquetWriter(OutputFile file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int rowGroupSize, boolean validating, Configuration conf, int maxPaddingSize, ParquetProperties encodingProps) throws IOException {
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        MessageType schema = writeContext.getSchema();
        ParquetFileWriter fileWriter = new ParquetFileWriter(file, schema, mode, (long)rowGroupSize, maxPaddingSize);
        fileWriter.start();
        this.codecFactory = new CodecFactory(conf, encodingProps.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = this.codecFactory.getCompressor(compressionCodecName);
        this.writer = new InternalParquetRecordWriter<T>(fileWriter, writeSupport, schema, writeContext.getExtraMetaData(), rowGroupSize, compressor, validating, encodingProps);
    }

    public void write(T object) throws IOException {
        try {
            this.writer.write(object);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.codecFactory.release();
        }
    }

    public ParquetMetadata getFooter() {
        return this.writer.getFooter();
    }

    public long getDataSize() {
        return this.writer.getDataSize();
    }

    public static abstract class Builder<T, SELF extends Builder<T, SELF>> {
        private OutputFile file = null;
        private Path path = null;
        private Configuration conf = new Configuration();
        private ParquetFileWriter.Mode mode;
        private CompressionCodecName codecName = DEFAULT_COMPRESSION_CODEC_NAME;
        private int rowGroupSize = 0x8000000;
        private int maxPaddingSize = 0x800000;
        private boolean enableValidation = false;
        private ParquetProperties.Builder encodingPropsBuilder = ParquetProperties.builder();

        protected Builder(Path path) {
            this.path = path;
        }

        protected Builder(OutputFile path) {
            this.file = path;
        }

        protected abstract SELF self();

        protected abstract WriteSupport<T> getWriteSupport(Configuration var1);

        public SELF withConf(Configuration conf) {
            this.conf = conf;
            return this.self();
        }

        public SELF withWriteMode(ParquetFileWriter.Mode mode) {
            this.mode = mode;
            return this.self();
        }

        public SELF withCompressionCodec(CompressionCodecName codecName) {
            this.codecName = codecName;
            return this.self();
        }

        public SELF withRowGroupSize(int rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this.self();
        }

        public SELF withPageSize(int pageSize) {
            this.encodingPropsBuilder.withPageSize(pageSize);
            return this.self();
        }

        public SELF withDictionaryPageSize(int dictionaryPageSize) {
            this.encodingPropsBuilder.withDictionaryPageSize(dictionaryPageSize);
            return this.self();
        }

        public SELF withMaxPaddingSize(int maxPaddingSize) {
            this.maxPaddingSize = maxPaddingSize;
            return this.self();
        }

        public SELF enableDictionaryEncoding() {
            this.encodingPropsBuilder.withDictionaryEncoding(true);
            return this.self();
        }

        public SELF withDictionaryEncoding(boolean enableDictionary) {
            this.encodingPropsBuilder.withDictionaryEncoding(enableDictionary);
            return this.self();
        }

        public SELF enableValidation() {
            this.enableValidation = true;
            return this.self();
        }

        public SELF withValidation(boolean enableValidation) {
            this.enableValidation = enableValidation;
            return this.self();
        }

        public SELF withWriterVersion(ParquetProperties.WriterVersion version) {
            this.encodingPropsBuilder.withWriterVersion(version);
            return this.self();
        }

        public SELF config(String property, String value) {
            this.conf.set(property, value);
            return this.self();
        }

        public ParquetWriter<T> build() throws IOException {
            if (this.file != null) {
                return new ParquetWriter<T>(this.file, this.mode, this.getWriteSupport(this.conf), this.codecName, this.rowGroupSize, this.enableValidation, this.conf, this.maxPaddingSize, this.encodingPropsBuilder.build());
            }
            return new ParquetWriter<T>(HadoopOutputFile.fromPath(this.path, this.conf), this.mode, this.getWriteSupport(this.conf), this.codecName, this.rowGroupSize, this.enableValidation, this.conf, this.maxPaddingSize, this.encodingPropsBuilder.build());
        }
    }
}

