/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hudi.org.apache.parquet.io.OutputFile;
import org.apache.hudi.org.apache.parquet.io.PositionOutputStream;

public class OutputStreamBackedOutputFile
implements OutputFile {
    private static final long DEFAULT_BLOCK_SIZE = 0x100000L;
    private final FSDataOutputStream outputStream;

    public OutputStreamBackedOutputFile(FSDataOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public PositionOutputStream create(long blockSizeHint) {
        return new PositionOutputStreamAdapter(this.outputStream);
    }

    @Override
    public PositionOutputStream createOrOverwrite(long blockSizeHint) {
        return this.create(blockSizeHint);
    }

    @Override
    public boolean supportsBlockSize() {
        return false;
    }

    @Override
    public long defaultBlockSize() {
        return 0x100000L;
    }

    private static class PositionOutputStreamAdapter
    extends PositionOutputStream {
        private final FSDataOutputStream delegate;

        PositionOutputStreamAdapter(FSDataOutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
            this.delegate.write(buffer, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() {
        }
    }
}

