/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metastore Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations used by the Hudi Metastore.")
@Immutable
public class HoodieMetastoreConfig
extends HoodieConfig {
    public static final String METASTORE_PREFIX = "hoodie.metastore";
    public static final ConfigProperty<Boolean> METASTORE_ENABLE = ConfigProperty.key("hoodie.metastore.enable").defaultValue(false).withDocumentation("Use metastore server to store hoodie table metadata");
    public static final ConfigProperty<String> METASTORE_URLS = ConfigProperty.key("hoodie.metastore.uris").defaultValue("thrift://localhost:9090").withDocumentation("Metastore server uris");
    public static final ConfigProperty<Integer> METASTORE_CONNECTION_RETRIES = ConfigProperty.key("hoodie.metastore.connect.retries").defaultValue(3).withDocumentation("Number of retries while opening a connection to metastore");
    public static final ConfigProperty<Integer> METASTORE_CONNECTION_RETRY_DELAY = ConfigProperty.key("hoodie.metastore.connect.retry.delay").defaultValue(1).withDocumentation("Number of seconds for the client to wait between consecutive connection attempts");

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean enableMetastore() {
        return this.getBoolean(METASTORE_ENABLE);
    }

    public String getMetastoreUris() {
        return this.getStringOrDefault(METASTORE_URLS);
    }

    public int getConnectionRetryLimit() {
        return this.getIntOrDefault(METASTORE_CONNECTION_RETRIES);
    }

    public int getConnectionRetryDelay() {
        return this.getIntOrDefault(METASTORE_CONNECTION_RETRY_DELAY);
    }

    public static class Builder {
        private final HoodieMetastoreConfig config = new HoodieMetastoreConfig();

        public Builder fromProperties(Properties props) {
            this.config.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder setUris(String uris) {
            this.config.setValue(METASTORE_URLS, uris);
            return this;
        }

        public HoodieMetastoreConfig build() {
            this.config.setDefaults(HoodieMetastoreConfig.class.getName());
            return this.config;
        }
    }
}

