/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.avro.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hudi.org.apache.avro.file.DataFileConstants;
import org.apache.hudi.org.apache.avro.file.DataFileReader12;
import org.apache.hudi.org.apache.avro.file.DataFileStream;
import org.apache.hudi.org.apache.avro.file.FileReader;
import org.apache.hudi.org.apache.avro.file.SeekableFileInput;
import org.apache.hudi.org.apache.avro.file.SeekableInput;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;

public class DataFileReader<D>
extends DataFileStream<D>
implements FileReader<D> {
    private SeekableInputStream sin;
    private long blockStart;

    public static <D> FileReader<D> openReader(File file, DatumReader<D> reader) throws IOException {
        return DataFileReader.openReader(new SeekableFileInput(file), reader);
    }

    public static <D> FileReader<D> openReader(SeekableInput in, DatumReader<D> reader) throws IOException {
        if (in.length() < (long)DataFileConstants.MAGIC.length) {
            throw new IOException("Not an Avro data file");
        }
        byte[] magic = new byte[DataFileConstants.MAGIC.length];
        in.seek(0L);
        int c = 0;
        while (c < magic.length) {
            c = in.read(magic, c, magic.length - c);
        }
        in.seek(0L);
        if (Arrays.equals(DataFileConstants.MAGIC, magic)) {
            return new DataFileReader<D>(in, reader);
        }
        if (Arrays.equals(DataFileReader12.MAGIC, magic)) {
            return new DataFileReader12<D>(in, reader);
        }
        throw new IOException("Not an Avro data file");
    }

    public static <D> DataFileReader<D> openReader(SeekableInput in, DatumReader<D> reader, DataFileStream.Header header, boolean sync) throws IOException {
        DataFileReader<D> dreader = new DataFileReader<D>(in, reader, header);
        if (sync) {
            dreader.sync(in.tell());
        } else {
            dreader.seek(in.tell());
        }
        return dreader;
    }

    public DataFileReader(File file, DatumReader<D> reader) throws IOException {
        this(new SeekableFileInput(file), reader);
    }

    public DataFileReader(SeekableInput sin, DatumReader<D> reader) throws IOException {
        super(reader);
        this.sin = new SeekableInputStream(sin);
        this.initialize(this.sin);
        this.blockFinished();
    }

    protected DataFileReader(SeekableInput sin, DatumReader<D> reader, DataFileStream.Header header) throws IOException {
        super(reader);
        this.sin = new SeekableInputStream(sin);
        this.initialize(this.sin, header);
    }

    public void seek(long position) throws IOException {
        this.sin.seek(position);
        this.vin = DecoderFactory.get().binaryDecoder(this.sin, this.vin);
        this.datumIn = null;
        this.blockRemaining = 0L;
        this.blockStart = position;
    }

    @Override
    public void sync(long position) throws IOException {
        this.seek(position);
        if (position == 0L && this.getMeta("avro.sync") != null) {
            this.initialize(this.sin);
            return;
        }
        try {
            int b;
            int i = 0;
            InputStream in = this.vin.inputStream();
            this.vin.readFixed(this.syncBuffer);
            do {
                int j;
                for (j = 0; j < 16 && this.getHeader().sync[j] == this.syncBuffer[(i + j) % 16]; ++j) {
                }
                if (j == 16) {
                    this.blockStart = position + (long)i + 16L;
                    return;
                }
                b = in.read();
                this.syncBuffer[i++ % 16] = (byte)b;
            } while (b != -1);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.blockStart = this.sin.tell();
    }

    @Override
    protected void blockFinished() throws IOException {
        this.blockStart = this.sin.tell() - (long)this.vin.inputStream().available();
    }

    public long previousSync() {
        return this.blockStart;
    }

    @Override
    public boolean pastSync(long position) throws IOException {
        return this.blockStart >= position + 16L || this.blockStart >= this.sin.length();
    }

    @Override
    public long tell() throws IOException {
        return this.sin.tell();
    }

    static class SeekableInputStream
    extends InputStream
    implements SeekableInput {
        private final byte[] oneByte = new byte[1];
        private SeekableInput in;

        SeekableInputStream(SeekableInput in) throws IOException {
            this.in = in;
        }

        @Override
        public void seek(long p) throws IOException {
            if (p < 0L) {
                throw new IOException("Illegal seek: " + p);
            }
            this.in.seek(p);
        }

        @Override
        public long tell() throws IOException {
            return this.in.tell();
        }

        @Override
        public long length() throws IOException {
            return this.in.length();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.oneByte, 0, 1);
            if (n == 1) {
                return this.oneByte[0] & 0xFF;
            }
            return n;
        }

        @Override
        public long skip(long skip) throws IOException {
            long position = this.in.tell();
            long length = this.in.length();
            long remaining = length - position;
            if (remaining > skip) {
                this.in.seek(skip);
                return this.in.tell() - position;
            }
            this.in.seek(remaining);
            return this.in.tell() - position;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            super.close();
        }

        @Override
        public int available() throws IOException {
            long remaining = this.in.length() - this.in.tell();
            return remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
        }
    }
}

