/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.parquet.hadoop.metadata;

import java.util.Set;
import org.apache.hudi.org.apache.parquet.column.Encoding;
import org.apache.hudi.org.apache.parquet.column.EncodingStats;
import org.apache.hudi.org.apache.parquet.column.statistics.Statistics;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.hudi.org.apache.parquet.schema.PrimitiveType;

class LongColumnChunkMetaData
extends ColumnChunkMetaData {
    private final long firstDataPageOffset;
    private final long dictionaryPageOffset;
    private final long valueCount;
    private final long totalSize;
    private final long totalUncompressedSize;
    private final Statistics statistics;

    LongColumnChunkMetaData(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPageOffset, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(encodingStats, ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPageOffset = firstDataPageOffset;
        this.dictionaryPageOffset = dictionaryPageOffset;
        this.valueCount = valueCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.statistics = statistics;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.firstDataPageOffset;
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.dictionaryPageOffset;
    }

    @Override
    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

