/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.shaded.parquet.org.apache.thrift;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T> {
    public abstract boolean isDefined();

    public abstract T get();

    public T or(T other) {
        if (this.isDefined()) {
            return this.get();
        }
        return other;
    }

    public static <T> Option<T> fromNullable(T value) {
        if (value != null) {
            return new Some<T>(value);
        }
        return new None();
    }

    public static <T> Some<T> some(T value) {
        return new Some<T>(value);
    }

    public static <T> None<T> none() {
        return new None();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Some<T>
    extends Option<T> {
        private final T value;

        public Some(T value) {
            this.value = value;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        public String toString() {
            return "Some(" + this.value.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class None<T>
    extends Option<T> {
        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalStateException("Cannot call get() on None");
        }

        public String toString() {
            return "None";
        }
    }
}

