/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false, false),
    HDFS("hdfs", true, false),
    AFS("afs", true, null),
    MAPRFS("maprfs", true, null),
    IGNITE("igfs", true, null),
    S3A("s3a", false, true),
    S3("s3", false, true),
    GCS("gs", false, true),
    WASB("wasb", false, null),
    WASBS("wasbs", false, null),
    ADL("adl", false, null),
    ABFS("abfs", false, null),
    ABFSS("abfss", false, null),
    OSS("oss", false, null),
    VIEWFS("viewfs", true, null),
    ALLUXIO("alluxio", false, null),
    COSN("cosn", false, null),
    CHDFS("ofs", true, null),
    GOOSEFS("gfs", false, null),
    DBFS("dbfs", false, null),
    COS("cos", false, null),
    OBS("obs", false, null),
    KS3("ks3", false, null),
    JFS("jfs", true, null),
    BOS("bos", false, null),
    OCI("oci", false, null),
    TOS("tos", false, null),
    CFS("cfs", true, null);

    private String scheme;
    private boolean supportsAppend;
    private Boolean isWriteTransactional;

    private StorageSchemes(String scheme, boolean supportsAppend, Boolean isWriteTransactional) {
        this.scheme = scheme;
        this.supportsAppend = supportsAppend;
        this.isWriteTransactional = isWriteTransactional;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public boolean isWriteTransactional() {
        return this.isWriteTransactional != null && this.isWriteTransactional != false;
    }

    public static boolean isSchemeSupported(String scheme) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme));
    }

    public static boolean isAppendSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.supportsAppend() && s.scheme.equals(scheme));
    }

    public static boolean isWriteTransactional(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isWriteTransactional() && s.scheme.equals(scheme));
    }
}

