/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.io.ByteBufferPool;

public class InLineFsDataInputStream
extends FSDataInputStream {
    private final long startOffset;
    private final FSDataInputStream outerStream;
    private final long length;

    public InLineFsDataInputStream(long startOffset, FSDataInputStream outerStream, long length) throws IOException {
        super(outerStream.getWrappedStream());
        this.startOffset = startOffset;
        this.outerStream = outerStream;
        this.length = length;
        outerStream.seek(startOffset);
    }

    public void seek(long desired) throws IOException {
        if (desired > this.length) {
            throw new IOException("Attempting to seek past inline content");
        }
        this.outerStream.seek(this.startOffset + desired);
    }

    public long getPos() throws IOException {
        return this.outerStream.getPos() - this.startOffset;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if ((long)(length + offset) > this.length) {
            throw new IOException("Attempting to read past inline content");
        }
        return this.outerStream.read(this.startOffset + position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        if ((long)(length + offset) > this.length) {
            throw new IOException("Attempting to read past inline content");
        }
        this.outerStream.readFully(this.startOffset + position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        if (targetPos > this.length) {
            throw new IOException("Attempting to seek past inline content");
        }
        return this.outerStream.seekToNewSource(this.startOffset + targetPos);
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.outerStream.read(buf);
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.outerStream.getFileDescriptor();
    }

    public void setReadahead(Long readahead) throws IOException, UnsupportedOperationException {
        if (readahead > this.length) {
            throw new IOException("Attempting to set read ahead past inline content");
        }
        this.outerStream.setReadahead(readahead);
    }

    public void setDropBehind(Boolean dropBehind) throws IOException, UnsupportedOperationException {
        this.outerStream.setDropBehind(dropBehind);
    }

    public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        if ((long)maxLength > this.length) {
            throw new IOException("Attempting to read max length beyond inline content");
        }
        return this.outerStream.read(bufferPool, maxLength, opts);
    }

    public void releaseBuffer(ByteBuffer buffer) {
        this.outerStream.releaseBuffer(buffer);
    }

    public void unbuffer() {
        this.outerStream.unbuffer();
    }
}

