/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieMergeArchiveFilePlan;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieArchivedTimeline
extends HoodieDefaultTimeline {
    public static final String MERGE_ARCHIVE_PLAN_NAME = "mergeArchivePlan";
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^\\.commits_\\.archive\\.([0-9]+).*");
    private static final String HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX = "commits";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final String ACTION_STATE = "actionState";
    private HoodieTableMetaClient metaClient;
    private final Map<String, byte[]> readCommits = new HashMap<String, byte[]>();
    private static final Logger LOG = LogManager.getLogger(HoodieArchivedTimeline.class);

    public HoodieArchivedTimeline(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(false));
        this.details = this::getInstantDetails;
    }

    public HoodieArchivedTimeline(HoodieTableMetaClient metaClient, String startTs) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(new StartTsFilter(startTs), true, record -> HoodieInstant.State.COMPLETED.toString().equals(record.get(ACTION_STATE).toString())));
        this.details = this::getInstantDetails;
    }

    public HoodieArchivedTimeline() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static Path getArchiveLogPath(String archiveFolder) {
        return new Path(archiveFolder, HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX);
    }

    public void loadInstantDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(startTs, endTs);
    }

    public void loadCompletedInstantDetailsInMemory() {
        this.loadInstants(null, true, record -> HoodieInstant.State.COMPLETED.toString().equals(record.get(ACTION_STATE).toString()));
    }

    public void loadCompactionDetailsInMemory(String compactionInstantTime) {
        this.loadCompactionDetailsInMemory(compactionInstantTime, compactionInstantTime);
    }

    public void loadCompactionDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(new TimeRangeFilter(startTs, endTs), true, record -> record.get(ACTION_TYPE_KEY).toString().equals("compaction") && HoodieInstant.State.INFLIGHT.toString().equals(record.get(ACTION_STATE).toString()));
    }

    public void clearInstantDetailsFromMemory(String instantTime) {
        this.readCommits.remove(instantTime);
    }

    public void clearInstantDetailsFromMemory(String startTs, String endTs) {
        this.findInstantsInRange(startTs, endTs).getInstants().forEach(instant -> this.readCommits.remove(instant.getTimestamp()));
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable(this.readCommits.get(instant.getTimestamp()));
    }

    public HoodieArchivedTimeline reload() {
        return new HoodieArchivedTimeline(this.metaClient);
    }

    private HoodieInstant readCommit(GenericRecord record, boolean loadDetails) {
        String instantTime = record.get("commitTime").toString();
        String action = record.get(ACTION_TYPE_KEY).toString();
        if (loadDetails) {
            this.getMetadataKey(action).map(key -> {
                Object actionData = record.get((String)key);
                if (actionData != null) {
                    if (action.equals("compaction")) {
                        this.readCommits.put(instantTime, HoodieAvroUtils.indexedRecordToBytes((IndexedRecord)actionData));
                    } else {
                        this.readCommits.put(instantTime, actionData.toString().getBytes(StandardCharsets.UTF_8));
                    }
                }
                return null;
            });
        }
        return new HoodieInstant(HoodieInstant.State.valueOf(record.get(ACTION_STATE).toString()), action, instantTime);
    }

    @Nonnull
    private Option<String> getMetadataKey(String action) {
        switch (action) {
            case "clean": {
                return Option.of("hoodieCleanMetadata");
            }
            case "commit": 
            case "deltacommit": {
                return Option.of("hoodieCommitMetadata");
            }
            case "rollback": {
                return Option.of("hoodieRollbackMetadata");
            }
            case "savepoint": {
                return Option.of("hoodieSavePointMetadata");
            }
            case "compaction": 
            case "logcompaction": {
                return Option.of("hoodieCompactionPlan");
            }
            case "replacecommit": {
                return Option.of("hoodieReplaceCommitMetadata");
            }
            case "indexing": {
                return Option.of("hoodieIndexCommitMetadata");
            }
        }
        LOG.error((Object)String.format("Unknown action in metadata (%s)", action));
        return Option.empty();
    }

    private List<HoodieInstant> loadInstants(boolean loadInstantDetails) {
        return this.loadInstants(null, loadInstantDetails);
    }

    private List<HoodieInstant> loadInstants(String startTs, String endTs) {
        return this.loadInstants(new TimeRangeFilter(startTs, endTs), true);
    }

    private List<HoodieInstant> loadInstants(TimeRangeFilter filter, boolean loadInstantDetails) {
        return this.loadInstants(filter, loadInstantDetails, record -> true);
    }

    private List<HoodieInstant> loadInstants(TimeRangeFilter filter, boolean loadInstantDetails, Function<GenericRecord, Boolean> commitsFilter) {
        try {
            FileStatus[] fsStatuses = this.metaClient.getFs().globStatus(new Path(this.metaClient.getArchivePath() + "/.commits_.archive*"));
            Arrays.sort(fsStatuses, new ArchiveFileVersionComparator());
            HashSet instantsInRange = new HashSet();
            for (FileStatus fs : fsStatuses) {
                try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(this.metaClient.getFs(), new HoodieLogFile(fs.getPath()), HoodieArchivedMetaEntry.getClassSchema());){
                    int instantsInPreviousFile = instantsInRange.size();
                    while (reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)reader.next();
                        if (!(block instanceof HoodieAvroDataBlock)) continue;
                        HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                        ClosableIterator itr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        Throwable throwable = null;
                        try {
                            StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 1024), true).map(r -> (GenericRecord)r.getData()).filter(commitsFilter::apply).map(r -> this.readCommit((GenericRecord)r, loadInstantDetails)).filter((? super T c) -> filter == null || filter.isInRange((HoodieInstant)c)).forEach(instantsInRange::add);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (itr == null) continue;
                            if (throwable != null) {
                                try {
                                    itr.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            itr.close();
                        }
                    }
                    if (filter == null) continue;
                    int instantsInCurrentFile = instantsInRange.size() - instantsInPreviousFile;
                    if (instantsInPreviousFile <= 0 || instantsInCurrentFile != 0) continue;
                    break;
                }
                catch (Exception originalException) {
                    try {
                        HoodieMergeArchiveFilePlan plan;
                        String mergedArchiveFileName;
                        Path planPath = new Path(this.metaClient.getArchivePath(), MERGE_ARCHIVE_PLAN_NAME);
                        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
                        if (!fileSystem.exists(planPath) || StringUtils.isNullOrEmpty(mergedArchiveFileName = (plan = TimelineMetadataUtils.deserializeAvroMetadata(FileIOUtils.readDataFromPath(fileSystem, planPath).get(), HoodieMergeArchiveFilePlan.class)).getMergedArchiveFileName()) || !fs.getPath().getName().equalsIgnoreCase(mergedArchiveFileName)) {
                            throw originalException;
                        }
                        LOG.warn((Object)("Catch exception because of reading uncompleted merging archive file " + mergedArchiveFileName + ". Ignore it here."));
                    }
                    catch (Exception e) {
                        throw originalException;
                    }
                }
            }
            ArrayList<HoodieInstant> result = new ArrayList<HoodieInstant>(instantsInRange);
            Collections.sort(result);
            return result;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + this.metaClient.getArchivePath(), e);
        }
    }

    @Override
    public HoodieDefaultTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit");
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T i) -> this.readCommits.containsKey(i.getTimestamp())).filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    public static class ArchiveFileVersionComparator
    implements Comparator<FileStatus>,
    Serializable {
        @Override
        public int compare(FileStatus f1, FileStatus f2) {
            return Integer.compare(this.getArchivedFileSuffix(f2), this.getArchivedFileSuffix(f1));
        }

        private int getArchivedFileSuffix(FileStatus f) {
            try {
                Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(f.getPath().getName());
                if (fileMatcher.matches()) {
                    return Integer.parseInt(fileMatcher.group(1));
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("error getting suffix for archived file: " + f.getPath()));
            }
            return 0;
        }
    }

    private static class StartTsFilter
    extends TimeRangeFilter {
        private final String startTs;

        public StartTsFilter(String startTs) {
            super(startTs, null);
            this.startTs = startTs;
        }

        @Override
        public boolean isInRange(HoodieInstant instant) {
            return HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN_OR_EQUALS, this.startTs);
        }
    }

    private static class TimeRangeFilter {
        private final String startTs;
        private final String endTs;

        public TimeRangeFilter(String startTs, String endTs) {
            this.startTs = startTs;
            this.endTs = endTs;
        }

        public boolean isInRange(HoodieInstant instant) {
            return HoodieTimeline.isInRange(instant.getTimestamp(), this.startTs, this.endTs);
        }
    }
}

