/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class StringUtils {
    public static final String EMPTY_STRING = "";

    public static <T> String join(String ... elements) {
        return StringUtils.join(elements, EMPTY_STRING);
    }

    public static <T> String joinUsingDelim(String delim, String ... elements) {
        return StringUtils.join(elements, delim);
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        return org.apache.hadoop.util.StringUtils.join((CharSequence)separator, (String[])array);
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        if (elements == null) {
            return null;
        }
        return String.join(delimiter, elements);
    }

    public static String join(List<String> list, String separator) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return org.apache.hadoop.util.StringUtils.join((CharSequence)separator, (String[])list.toArray(new String[0]));
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean nonEmpty(String str) {
        return !StringUtils.isNullOrEmpty(str);
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static String objToString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof ByteBuffer ? StringUtils.toHexString(((ByteBuffer)obj).array()) : obj.toString();
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return StringUtils.stringIsNullOrEmpty(string) ? null : string;
    }

    private static boolean stringIsNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static List<String> split(@Nullable String input, String delimiter) {
        if (StringUtils.isNullOrEmpty(input)) {
            return Collections.emptyList();
        }
        return Stream.of(input.split(delimiter)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static String getSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(i);
    }

    public static String removeSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(0, i);
    }
}

