/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeBootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRealtimeInputFormatUtils
extends HoodieInputFormatUtils {
    private static final Logger LOG = LogManager.getLogger(HoodieRealtimeInputFormatUtils.class);

    public static boolean doesBelongToIncrementalQuery(FileSplit s) {
        if (s instanceof HoodieRealtimeFileSplit) {
            HoodieRealtimeFileSplit bs = (HoodieRealtimeFileSplit)TypeUtils.unsafeCast(s);
            return bs.getBelongsToIncrementalQuery();
        }
        if (s instanceof HoodieRealtimeBootstrapBaseFileSplit) {
            HoodieRealtimeBootstrapBaseFileSplit bs = (HoodieRealtimeBootstrapBaseFileSplit)TypeUtils.unsafeCast(s);
            return bs.getBelongsToIncrementalQuery();
        }
        return false;
    }

    private static Configuration addProjectionField(Configuration conf, String fieldName, int fieldIndex) {
        String readColNames = conf.get("hive.io.file.readcolumn.names", "");
        String readColIds = conf.get("hive.io.file.readcolumn.ids", "");
        String readColNamesPrefix = readColNames + ",";
        if (readColNames == null || readColNames.isEmpty()) {
            readColNamesPrefix = "";
        }
        String readColIdsPrefix = readColIds + ",";
        if (readColIds == null || readColIds.isEmpty()) {
            readColIdsPrefix = "";
        }
        if (!readColNames.contains(fieldName)) {
            conf.set("hive.io.file.readcolumn.names", readColNamesPrefix + fieldName);
            conf.set("hive.io.file.readcolumn.ids", readColIdsPrefix + fieldIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding extra column " + fieldName + ", to enable log merging cols (%s) ids (%s) ", conf.get("hive.io.file.readcolumn.names"), conf.get("hive.io.file.readcolumn.ids")));
            }
        }
        return conf;
    }

    public static void addRequiredProjectionFields(Configuration configuration, Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo, Option<String> preCombineKeyOpt) {
        if (!hoodieVirtualKeyInfo.isPresent()) {
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, HoodieRecord.RECORD_KEY_METADATA_FIELD, 2);
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, HoodieRecord.COMMIT_TIME_METADATA_FIELD, 0);
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, HoodieRecord.PARTITION_PATH_METADATA_FIELD, 3);
        } else {
            HoodieVirtualKeyInfo hoodieVirtualKey = hoodieVirtualKeyInfo.get();
            HoodieRealtimeInputFormatUtils.addProjectionField(configuration, hoodieVirtualKey.getRecordKeyField(), hoodieVirtualKey.getRecordKeyFieldIndex());
            if (hoodieVirtualKey.getPartitionPathField().isPresent()) {
                HoodieRealtimeInputFormatUtils.addProjectionField(configuration, hoodieVirtualKey.getPartitionPathField().get(), hoodieVirtualKey.getPartitionPathFieldIndex().get());
            }
        }
        if (preCombineKeyOpt.isPresent()) {
            String preCombineKey = preCombineKeyOpt.get();
            List columnNameList = Arrays.stream(configuration.get("columns").split(",")).collect(Collectors.toList());
            int pos = columnNameList.indexOf(preCombineKey);
            if (pos != -1) {
                HoodieRealtimeInputFormatUtils.addProjectionField(configuration, preCombineKey, pos);
                LOG.info((Object)String.format("add preCombineKey: %s to project columns with position %s", preCombineKey, pos));
            }
        }
    }

    public static boolean requiredProjectionFieldsExistInConf(Configuration configuration, Option<HoodieVirtualKeyInfo> hoodieVirtualKeyInfo) {
        String readColNames = configuration.get("hive.io.file.readcolumn.names", "");
        if (!hoodieVirtualKeyInfo.isPresent()) {
            return readColNames.contains(HoodieRecord.RECORD_KEY_METADATA_FIELD) && readColNames.contains(HoodieRecord.COMMIT_TIME_METADATA_FIELD) && readColNames.contains(HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        }
        return readColNames.contains(hoodieVirtualKeyInfo.get().getRecordKeyField()) && (!hoodieVirtualKeyInfo.get().getPartitionPathField().isPresent() || readColNames.contains(hoodieVirtualKeyInfo.get().getPartitionPathField().get()));
    }

    public static boolean canAddProjectionToJobConf(RealtimeSplit realtimeSplit, JobConf jobConf) {
        return jobConf.get("hoodie.read.columns.set") == null || !realtimeSplit.getDeltaLogPaths().isEmpty() && !HoodieRealtimeInputFormatUtils.requiredProjectionFieldsExistInConf((Configuration)jobConf, realtimeSplit.getVirtualKeyInfo());
    }

    public static void cleanProjectionColumnIds(Configuration conf) {
        String columnIds = conf.get("hive.io.file.readcolumn.ids");
        if (!columnIds.isEmpty() && columnIds.charAt(0) == ',') {
            conf.set("hive.io.file.readcolumn.ids", columnIds.substring(1));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The projection Ids: {" + columnIds + "} start with ','. First comma is removed"));
            }
        }
    }
}

