/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.Cursor;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ScannerCallable
extends ClientServiceCallable<Result[]> {
    public static final String LOG_SCANNER_LATENCY_CUTOFF = "hbase.client.log.scanner.latency.cutoff";
    public static final String LOG_SCANNER_ACTIVITY = "hbase.client.log.scanner.activity";
    public static final Logger LOG = LoggerFactory.getLogger(ScannerCallable.class);
    protected long scannerId = -1L;
    protected boolean instantiated = false;
    protected boolean closed = false;
    protected boolean renew = false;
    protected final Scan scan;
    private int caching = 1;
    protected ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    protected final int id;
    private MoreResults moreResultsInRegion;
    private MoreResults moreResultsForScan;
    protected boolean heartbeatMessage = false;
    protected Cursor cursor;
    protected boolean isRegionServerRemote = true;
    private long nextCallSeq = 0L;
    protected final RpcControllerFactory rpcControllerFactory;

    public ScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcControllerFactory, int id) {
        super(connection, tableName, scan.getStartRow(), rpcControllerFactory.newController(), scan.getPriority());
        this.id = id;
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = connection.getConfiguration();
        this.logScannerActivity = conf.getBoolean(LOG_SCANNER_ACTIVITY, false);
        this.logCutOffLatency = conf.getInt(LOG_SCANNER_LATENCY_CUTOFF, 1000);
        this.rpcControllerFactory = rpcControllerFactory;
    }

    protected final HRegionLocation getLocationForReplica(RegionLocations locs) throws HBaseIOException {
        HRegionLocation loc;
        HRegionLocation hRegionLocation = loc = this.id < locs.size() ? locs.getRegionLocation(this.id) : null;
        if (loc == null || loc.getServerName() == null) {
            throw new HBaseIOException("There is no location for replica id #" + this.id);
        }
        return loc;
    }

    protected final RegionLocations getRegionLocations(boolean reload, byte[] row) throws IOException {
        return RpcRetryingCallerWithReadReplicas.getRegionLocations(!reload, this.id, this.getConnection(), this.getTableName(), row);
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        RegionLocations rl = this.getRegionLocations(reload, this.getRow());
        this.location = this.getLocationForReplica(rl);
        ServerName dest = this.location.getServerName();
        this.setStub(super.getConnection().getClient(dest));
        if (!this.instantiated || reload) {
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        this.cursor = null;
        if (reload) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, this.isRegionServerRemote);
        }
    }

    protected void checkIfRegionServerIsRemote() {
        this.isRegionServerRemote = ConnectionUtils.isRemote(this.getLocation().getHostname());
    }

    private ClientProtos.ScanResponse next() throws IOException {
        this.setHeartbeatMessage(false);
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.isRegionServerRemote);
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.scannerId, this.caching, false, this.nextCallSeq, this.scanMetrics != null, this.renew, this.scan.getLimit());
        try {
            ClientProtos.ScanResponse response = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).scan(this.getRpcController(), request);
            ++this.nextCallSeq;
            return response;
        }
        catch (Exception e) {
            IOException ioe = ProtobufUtil.handleRemoteException(e);
            if (this.logScannerActivity) {
                LOG.info("Got exception making request " + ProtobufUtil.toText(request) + " to " + this.getLocation(), (Throwable)e);
            }
            if (this.logScannerActivity) {
                if (ioe instanceof UnknownScannerException) {
                    try {
                        HRegionLocation location = this.getConnection().relocateRegion(this.getTableName(), this.scan.getStartRow());
                        LOG.info("Scanner=" + this.scannerId + " expired, current region location is " + location.toString());
                    }
                    catch (Throwable t) {
                        LOG.info("Failed to relocate region", t);
                    }
                } else if (ioe instanceof ScannerResetException) {
                    LOG.info("Scanner=" + this.scannerId + " has received an exception, and the server asked us to reset the scanner state.", (Throwable)ioe);
                }
            }
            if (ioe instanceof NotServingRegionException) {
                if (this.scanMetrics != null) {
                    this.scanMetrics.countOfNSRE.incrementAndGet();
                }
                throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
            }
            if (ioe instanceof RegionServerStoppedException) {
                throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
            }
            throw ioe;
        }
    }

    private void setAlreadyClosed() {
        this.scannerId = -1L;
        this.closed = true;
    }

    @Override
    protected Result[] rpcCall() throws Exception {
        long now;
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (this.closed) {
            this.close();
            return null;
        }
        ClientProtos.ScanResponse response = this.scannerId == -1L ? this.openScanner() : this.next();
        long timestamp = System.currentTimeMillis();
        boolean isHeartBeat = response.hasHeartbeatMessage() && response.getHeartbeatMessage();
        this.setHeartbeatMessage(isHeartBeat);
        if (isHeartBeat && this.scan.isNeedCursorResult() && response.hasCursor()) {
            this.cursor = ProtobufUtil.toCursor(response.getCursor());
        }
        Result[] rrs = ResponseConverter.getResults(this.getRpcControllerCellScanner(), response);
        if (this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)this.logCutOffLatency) {
            int rows = rrs == null ? 0 : rrs.length;
            LOG.info("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + this.scannerId);
        }
        ConnectionUtils.updateServerSideMetrics(this.scanMetrics, response);
        if (response.hasMoreResults()) {
            if (response.getMoreResults()) {
                this.setMoreResultsForScan(MoreResults.YES);
            } else {
                this.setMoreResultsForScan(MoreResults.NO);
                this.setAlreadyClosed();
            }
        } else {
            this.setMoreResultsForScan(MoreResults.UNKNOWN);
        }
        if (response.hasMoreResultsInRegion()) {
            if (response.getMoreResultsInRegion()) {
                this.setMoreResultsInRegion(MoreResults.YES);
            } else {
                this.setMoreResultsInRegion(MoreResults.NO);
                this.setAlreadyClosed();
            }
        } else {
            this.setMoreResultsInRegion(MoreResults.UNKNOWN);
        }
        ConnectionUtils.updateResultsMetrics(this.scanMetrics, rrs, this.isRegionServerRemote);
        return rrs;
    }

    boolean isHeartbeatMessage() {
        return this.heartbeatMessage;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setHeartbeatMessage(boolean heartbeatMessage) {
        this.heartbeatMessage = heartbeatMessage;
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.isRegionServerRemote);
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.scannerId, 0, true, this.scanMetrics != null);
            try {
                ((ClientProtos.ClientService.BlockingInterface)this.getStub()).scan(this.getRpcController(), request);
            }
            catch (Exception e) {
                throw ProtobufUtil.handleRemoteException(e);
            }
        }
        catch (IOException e) {
            TableName table = this.getTableName();
            String tableDetails = table == null ? "" : " on table: " + table.getNameAsString();
            LOG.warn("Ignore, probably already closed. Current scan: " + this.getScan().toString() + tableDetails, (Throwable)e);
        }
        this.scannerId = -1L;
    }

    private ClientProtos.ScanResponse openScanner() throws IOException {
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, this.isRegionServerRemote);
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.scan, this.caching, false);
        try {
            ClientProtos.ScanResponse response = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).scan(this.getRpcController(), request);
            long id = response.getScannerId();
            if (this.logScannerActivity) {
                LOG.info("Open scanner=" + id + " for scan=" + this.scan.toString() + " on region " + this.getLocation().toString());
            }
            if (response.hasMvccReadPoint()) {
                this.scan.setMvccReadPoint(response.getMvccReadPoint());
            }
            this.scannerId = id;
            return response;
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    public void setRenew(boolean val) {
        this.renew = val;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.getLocation().getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public ScannerCallable getScannerCallableForReplica(int id) {
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTableName(), this.getScan(), this.scanMetrics, this.rpcControllerFactory, id);
        s.setCaching(this.caching);
        return s;
    }

    MoreResults moreResultsInRegion() {
        return this.moreResultsInRegion;
    }

    void setMoreResultsInRegion(MoreResults moreResults) {
        this.moreResultsInRegion = moreResults;
    }

    MoreResults moreResultsForScan() {
        return this.moreResultsForScan;
    }

    void setMoreResultsForScan(MoreResults moreResults) {
        this.moreResultsForScan = moreResults;
    }

    static enum MoreResults {
        YES,
        NO,
        UNKNOWN;

    }
}

