/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableConfig;

public class ConfigUtils {
    public static String getOrderingField(Properties properties) {
        String orderField = null;
        if (properties.containsKey("hoodie.payload.ordering.field")) {
            orderField = properties.getProperty("hoodie.payload.ordering.field");
        } else if (properties.containsKey("hoodie.datasource.write.precombine.field")) {
            orderField = properties.getProperty("hoodie.datasource.write.precombine.field");
        } else if (properties.containsKey(HoodieTableConfig.PRECOMBINE_FIELD.key())) {
            orderField = properties.getProperty(HoodieTableConfig.PRECOMBINE_FIELD.key());
        }
        return orderField;
    }

    public static String getPayloadClass(Properties properties) {
        String payloadClass = null;
        if (properties.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME.key())) {
            payloadClass = properties.getProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key());
        } else if (properties.containsKey("hoodie.datasource.write.payload.class")) {
            payloadClass = properties.getProperty("hoodie.datasource.write.payload.class");
        }
        return payloadClass;
    }

    public static List<String> split2List(String param) {
        return Arrays.stream(param.split(",")).map(String::trim).distinct().collect(Collectors.toList());
    }
}

