/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Lazy<T> {
    private volatile boolean initialized;
    private Supplier<T> initializer;
    private T ref;

    private Lazy(Supplier<T> initializer) {
        this.initializer = initializer;
        this.ref = null;
        this.initialized = false;
    }

    private Lazy(T ref) {
        this.initializer = null;
        this.ref = ref;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    this.ref = this.initializer.get();
                    this.initializer = null;
                    this.initialized = true;
                }
            }
        }
        return this.ref;
    }

    public static <T> Lazy<T> lazily(Supplier<T> initializer) {
        return new Lazy<Supplier<T>>(initializer);
    }

    public static <T> Lazy<T> eagerly(T ref) {
        return new Lazy<T>(ref);
    }
}

