/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumReader;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieRecordIndexInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -459739777345513176L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieRecordIndexInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"partitionName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the partition name the record belongs to\",\"default\":null},{\"name\":\"fileIdHighBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to high 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIdLowBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to low 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.\",\"default\":null},{\"name\":\"instantTime\",\"type\":[\"null\",\"long\"],\"doc\":\"Epoch time in millisecond representing the commit time at which record was added\",\"default\":null},{\"name\":\"fileIdEncoding\",\"type\":\"int\",\"doc\":\"Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. \\nWhen the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.\",\"default\":0}]}");
    @Deprecated
    public String partitionName;
    @Deprecated
    public Long fileIdHighBits;
    @Deprecated
    public Long fileIdLowBits;
    @Deprecated
    public Integer fileIndex;
    @Deprecated
    public String fileId;
    @Deprecated
    public Long instantTime;
    @Deprecated
    public int fileIdEncoding;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public HoodieRecordIndexInfo() {
    }

    public HoodieRecordIndexInfo(String partitionName, Long fileIdHighBits, Long fileIdLowBits, Integer fileIndex, String fileId, Long instantTime, Integer fileIdEncoding) {
        this.partitionName = partitionName;
        this.fileIdHighBits = fileIdHighBits;
        this.fileIdLowBits = fileIdLowBits;
        this.fileIndex = fileIndex;
        this.fileId = fileId;
        this.instantTime = instantTime;
        this.fileIdEncoding = fileIdEncoding;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.partitionName;
            }
            case 1: {
                return this.fileIdHighBits;
            }
            case 2: {
                return this.fileIdLowBits;
            }
            case 3: {
                return this.fileIndex;
            }
            case 4: {
                return this.fileId;
            }
            case 5: {
                return this.instantTime;
            }
            case 6: {
                return this.fileIdEncoding;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.partitionName = (String)value$;
                break;
            }
            case 1: {
                this.fileIdHighBits = (Long)value$;
                break;
            }
            case 2: {
                this.fileIdLowBits = (Long)value$;
                break;
            }
            case 3: {
                this.fileIndex = (Integer)value$;
                break;
            }
            case 4: {
                this.fileId = (String)value$;
                break;
            }
            case 5: {
                this.instantTime = (Long)value$;
                break;
            }
            case 6: {
                this.fileIdEncoding = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String value) {
        this.partitionName = value;
    }

    public Long getFileIdHighBits() {
        return this.fileIdHighBits;
    }

    public void setFileIdHighBits(Long value) {
        this.fileIdHighBits = value;
    }

    public Long getFileIdLowBits() {
        return this.fileIdLowBits;
    }

    public void setFileIdLowBits(Long value) {
        this.fileIdLowBits = value;
    }

    public Integer getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(Integer value) {
        this.fileIndex = value;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String value) {
        this.fileId = value;
    }

    public Long getInstantTime() {
        return this.instantTime;
    }

    public void setInstantTime(Long value) {
        this.instantTime = value;
    }

    public Integer getFileIdEncoding() {
        return this.fileIdEncoding;
    }

    public void setFileIdEncoding(Integer value) {
        this.fileIdEncoding = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieRecordIndexInfo other) {
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<HoodieRecordIndexInfo>
    implements RecordBuilder<HoodieRecordIndexInfo> {
        private String partitionName;
        private Long fileIdHighBits;
        private Long fileIdLowBits;
        private Integer fileIndex;
        private String fileId;
        private Long instantTime;
        private int fileIdEncoding;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.partitionName)) {
                this.partitionName = this.data().deepCopy(this.fields()[0].schema(), other.partitionName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.fileIdHighBits)) {
                this.fileIdHighBits = this.data().deepCopy(this.fields()[1].schema(), other.fileIdHighBits);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.fileIdLowBits)) {
                this.fileIdLowBits = this.data().deepCopy(this.fields()[2].schema(), other.fileIdLowBits);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.fileIndex)) {
                this.fileIndex = this.data().deepCopy(this.fields()[3].schema(), other.fileIndex);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[4].schema(), other.fileId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.instantTime)) {
                this.instantTime = this.data().deepCopy(this.fields()[5].schema(), other.instantTime);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.fileIdEncoding)) {
                this.fileIdEncoding = this.data().deepCopy(this.fields()[6].schema(), other.fileIdEncoding);
                this.fieldSetFlags()[6] = true;
            }
        }

        private Builder(HoodieRecordIndexInfo other) {
            super(SCHEMA$);
            if (Builder.isValidValue(this.fields()[0], other.partitionName)) {
                this.partitionName = this.data().deepCopy(this.fields()[0].schema(), other.partitionName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.fileIdHighBits)) {
                this.fileIdHighBits = this.data().deepCopy(this.fields()[1].schema(), other.fileIdHighBits);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.fileIdLowBits)) {
                this.fileIdLowBits = this.data().deepCopy(this.fields()[2].schema(), other.fileIdLowBits);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.fileIndex)) {
                this.fileIndex = this.data().deepCopy(this.fields()[3].schema(), other.fileIndex);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[4].schema(), other.fileId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.instantTime)) {
                this.instantTime = this.data().deepCopy(this.fields()[5].schema(), other.instantTime);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.fileIdEncoding)) {
                this.fileIdEncoding = this.data().deepCopy(this.fields()[6].schema(), other.fileIdEncoding);
                this.fieldSetFlags()[6] = true;
            }
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public Builder setPartitionName(String value) {
            this.validate(this.fields()[0], value);
            this.partitionName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasPartitionName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearPartitionName() {
            this.partitionName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getFileIdHighBits() {
            return this.fileIdHighBits;
        }

        public Builder setFileIdHighBits(Long value) {
            this.validate(this.fields()[1], value);
            this.fileIdHighBits = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasFileIdHighBits() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearFileIdHighBits() {
            this.fileIdHighBits = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getFileIdLowBits() {
            return this.fileIdLowBits;
        }

        public Builder setFileIdLowBits(Long value) {
            this.validate(this.fields()[2], value);
            this.fileIdLowBits = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFileIdLowBits() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFileIdLowBits() {
            this.fileIdLowBits = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getFileIndex() {
            return this.fileIndex;
        }

        public Builder setFileIndex(Integer value) {
            this.validate(this.fields()[3], value);
            this.fileIndex = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasFileIndex() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearFileIndex() {
            this.fileIndex = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getFileId() {
            return this.fileId;
        }

        public Builder setFileId(String value) {
            this.validate(this.fields()[4], value);
            this.fileId = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFileId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFileId() {
            this.fileId = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getInstantTime() {
            return this.instantTime;
        }

        public Builder setInstantTime(Long value) {
            this.validate(this.fields()[5], value);
            this.instantTime = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasInstantTime() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearInstantTime() {
            this.instantTime = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getFileIdEncoding() {
            return this.fileIdEncoding;
        }

        public Builder setFileIdEncoding(int value) {
            this.validate(this.fields()[6], value);
            this.fileIdEncoding = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasFileIdEncoding() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearFileIdEncoding() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        @Override
        public HoodieRecordIndexInfo build() {
            try {
                HoodieRecordIndexInfo record = new HoodieRecordIndexInfo();
                record.partitionName = this.fieldSetFlags()[0] ? this.partitionName : (String)this.defaultValue(this.fields()[0]);
                record.fileIdHighBits = this.fieldSetFlags()[1] ? this.fileIdHighBits : (Long)this.defaultValue(this.fields()[1]);
                record.fileIdLowBits = this.fieldSetFlags()[2] ? this.fileIdLowBits : (Long)this.defaultValue(this.fields()[2]);
                record.fileIndex = this.fieldSetFlags()[3] ? this.fileIndex : (Integer)this.defaultValue(this.fields()[3]);
                record.fileId = this.fieldSetFlags()[4] ? this.fileId : (String)this.defaultValue(this.fields()[4]);
                record.instantTime = this.fieldSetFlags()[5] ? this.instantTime : (Long)this.defaultValue(this.fields()[5]);
                record.fileIdEncoding = this.fieldSetFlags()[6] ? this.fileIdEncoding : (Integer)this.defaultValue(this.fields()[6]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

