/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.util.Either;

public abstract class HoodieBaseListData<T> {
    protected final Either<Stream<T>, List<T>> data;
    protected final boolean lazy;

    protected HoodieBaseListData(List<T> data, boolean lazy) {
        this.data = lazy ? Either.left(data.stream().parallel()) : Either.right(data);
        this.lazy = lazy;
    }

    protected HoodieBaseListData(Stream<T> dataStream, boolean lazy) {
        this.data = lazy ? Either.left(dataStream) : Either.right(dataStream.collect(Collectors.toList()));
        this.lazy = lazy;
    }

    protected Stream<T> asStream() {
        return this.lazy ? this.data.asLeft() : this.data.asRight().parallelStream();
    }

    protected boolean isEmpty() {
        if (this.lazy) {
            return this.data.asLeft().findAny().isPresent();
        }
        return this.data.asRight().isEmpty();
    }

    protected long count() {
        if (this.lazy) {
            return this.data.asLeft().count();
        }
        return this.data.asRight().size();
    }

    protected List<T> collectAsList() {
        if (this.lazy) {
            return this.data.asLeft().collect(Collectors.toList());
        }
        return this.data.asRight();
    }
}

