/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TablePathUtils.class);

    private static boolean hasTableMetadataFolder(FileSystem fs, Path path) {
        if (path == null) {
            return false;
        }
        try {
            return fs.exists(new Path(path, ".hoodie"));
        }
        catch (IOException ioe) {
            throw new HoodieException("Error checking Hoodie metadata folder for " + path, ioe);
        }
    }

    public static boolean isHoodieTablePath(FileSystem fs, Path path) {
        return TablePathUtils.hasTableMetadataFolder(fs, path);
    }

    public static Option<Path> getTablePath(FileSystem fs, Path path) throws HoodieException, IOException {
        Path directory;
        LOG.info("Getting table path from path : " + path);
        FileStatus fileStatus = fs.getFileStatus(path);
        Path path2 = directory = fileStatus.isFile() ? fileStatus.getPath().getParent() : fileStatus.getPath();
        if (TablePathUtils.hasTableMetadataFolder(fs, directory)) {
            return Option.of(directory);
        }
        Option<Path> tablePath = TablePathUtils.getTablePathFromMetaFolderPath(directory);
        if (tablePath.isPresent()) {
            return tablePath;
        }
        return TablePathUtils.getTablePathFromPartitionPath(fs, directory);
    }

    private static boolean isInsideTableMetaFolder(String path) {
        return path != null && path.contains("/.hoodie");
    }

    private static boolean isInsideMetadataTableInMetaFolder(String path) {
        return path != null && path.contains("/.hoodie/metadata");
    }

    private static Option<Path> getTablePathFromMetaFolderPath(Path path) {
        String pathStr = path.toString();
        if (TablePathUtils.isInsideTableMetaFolder(pathStr) && !TablePathUtils.isInsideMetadataTableInMetaFolder(pathStr)) {
            int index = pathStr.indexOf("/.hoodie");
            return Option.of(new Path(pathStr.substring(0, index)));
        }
        return Option.empty();
    }

    private static Option<Path> getTablePathFromPartitionPath(FileSystem fs, Path partitionPath) {
        try {
            if (HoodiePartitionMetadata.hasPartitionMetadata(fs, partitionPath)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(fs, partitionPath);
                metadata.readFromFS();
                return Option.of(TablePathUtils.getNthParent(partitionPath, metadata.getPartitionDepth()));
            }
            for (Path current = partitionPath; current != null; current = current.getParent()) {
                if (!TablePathUtils.hasTableMetadataFolder(fs, current)) continue;
                return Option.of(current);
            }
            return Option.empty();
        }
        catch (IOException ioe) {
            throw new HoodieException("Error reading partition metadata for " + partitionPath, ioe);
        }
    }

    private static Path getNthParent(Path path, int n) {
        Path parent = path;
        for (int i = 0; i < n; ++i) {
            parent = parent.getParent();
        }
        return parent;
    }
}

