/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.apache.hudi.org.apache.avro.Schema;

public class AvroSchemaEvolutionUtils {
    public static InternalSchema reconcileSchema(Schema incomingSchema, InternalSchema oldTableSchema) {
        InternalSchema inComingInternalSchema = AvroInternalSchemaConverter.convert(incomingSchema);
        List<String> colNamesFromIncoming = inComingInternalSchema.getAllColsFullName();
        List<String> colNamesFromOldSchema = oldTableSchema.getAllColsFullName();
        List diffFromOldSchema = colNamesFromOldSchema.stream().filter(f -> !colNamesFromIncoming.contains(f)).collect(Collectors.toList());
        List diffFromEvolutionColumns = colNamesFromIncoming.stream().filter(f -> !colNamesFromOldSchema.contains(f)).collect(Collectors.toList());
        List typeChangeColumns = colNamesFromIncoming.stream().filter(f -> colNamesFromOldSchema.contains(f) && !inComingInternalSchema.findType((String)f).equals(oldTableSchema.findType((String)f))).collect(Collectors.toList());
        if (colNamesFromIncoming.size() == colNamesFromOldSchema.size() && diffFromOldSchema.size() == 0 && typeChangeColumns.isEmpty()) {
            return oldTableSchema;
        }
        TreeMap<Integer, String> finalAddAction = new TreeMap<Integer, String>();
        for (int i = 0; i < diffFromEvolutionColumns.size(); ++i) {
            String parentName;
            String name = (String)diffFromEvolutionColumns.get(i);
            int splitPoint = name.lastIndexOf(".");
            String string = parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            if (!parentName.isEmpty() && diffFromEvolutionColumns.contains(parentName)) continue;
            finalAddAction.put(inComingInternalSchema.findIdByName(name), name);
        }
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldTableSchema);
        finalAddAction.entrySet().stream().forEach(f -> {
            String name = (String)f.getValue();
            int splitPoint = name.lastIndexOf(".");
            String parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            String rawName = splitPoint > 0 ? name.substring(splitPoint + 1) : name;
            Optional<String> inferPosition = colNamesFromIncoming.stream().filter(c -> c.lastIndexOf(".") == splitPoint && c.startsWith(parentName) && inComingInternalSchema.findIdByName((String)c) > inComingInternalSchema.findIdByName(name) && oldTableSchema.findIdByName((String)c) > 0).sorted((s1, s2) -> oldTableSchema.findIdByName((String)s1) - oldTableSchema.findIdByName((String)s2)).findFirst();
            addChange.addColumns(parentName, rawName, inComingInternalSchema.findType(name), null);
            inferPosition.map(i -> addChange.addPositionChange(name, (String)i, "before"));
        });
        InternalSchema internalSchemaAfterAddColumns = SchemaChangeUtils.applyTableChanges2Schema(oldTableSchema, addChange);
        TableChanges.ColumnUpdateChange typeChange = TableChanges.ColumnUpdateChange.get(internalSchemaAfterAddColumns);
        typeChangeColumns.stream().filter(f -> !inComingInternalSchema.findType((String)f).isNestedType()).forEach(col -> typeChange.updateColumnType((String)col, inComingInternalSchema.findType((String)col)));
        return SchemaChangeUtils.applyTableChanges2Schema(internalSchemaAfterAddColumns, typeChange);
    }

    public static Schema reconcileNullability(Schema sourceSchema, Schema targetSchema, Map<String, String> opts) {
        if (sourceSchema.getFields().isEmpty() || targetSchema.getFields().isEmpty()) {
            return sourceSchema;
        }
        InternalSchema sourceInternalSchema = AvroInternalSchemaConverter.convert(sourceSchema);
        InternalSchema targetInternalSchema = AvroInternalSchemaConverter.convert(targetSchema);
        List<String> colNamesSourceSchema = sourceInternalSchema.getAllColsFullName();
        List<String> colNamesTargetSchema = targetInternalSchema.getAllColsFullName();
        List candidateUpdateCols = colNamesSourceSchema.stream().filter(f -> "true".equals(opts.get(HoodieCommonConfig.MAKE_NEW_COLUMNS_NULLABLE.key())) && !colNamesTargetSchema.contains(f) || colNamesTargetSchema.contains(f) && sourceInternalSchema.findField((String)f).isOptional() != targetInternalSchema.findField((String)f).isOptional()).collect(Collectors.toList());
        if (candidateUpdateCols.isEmpty()) {
            return sourceSchema;
        }
        TableChanges.ColumnUpdateChange schemaChange = CollectionUtils.reduce(candidateUpdateCols, TableChanges.ColumnUpdateChange.get(sourceInternalSchema), (change, field) -> change.updateColumnNullability((String)field, true));
        return AvroInternalSchemaConverter.convert(SchemaChangeUtils.applyTableChanges2Schema(sourceInternalSchema, schemaChange), sourceSchema.getFullName());
    }
}

