/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.hadoop.CachingPath;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieTableFileIndex
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieTableFileIndex.class);
    private final String[] partitionColumns;
    protected final HoodieMetadataConfig metadataConfig;
    private final HoodieTableQueryType queryType;
    private final Option<String> specifiedQueryInstant;
    private final Option<String> beginInstantTime;
    private final Option<String> endInstantTime;
    private final List<Path> queryPaths;
    private final boolean shouldIncludePendingCommits;
    private final boolean shouldValidateInstant;
    private final boolean shouldListLazily;
    private final Path basePath;
    private final HoodieTableMetaClient metaClient;
    private final HoodieEngineContext engineContext;
    private final transient FileStatusCache fileStatusCache;
    private volatile transient Map<PartitionPath, List<FileSlice>> cachedAllInputFileSlices = new HashMap<PartitionPath, List<FileSlice>>();
    private volatile transient List<PartitionPath> cachedAllPartitionPaths = null;
    private transient HoodieTableMetadata tableMetadata = null;

    public BaseHoodieTableFileIndex(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, TypedProperties configProperties, HoodieTableQueryType queryType, List<Path> queryPaths, Option<String> specifiedQueryInstant, boolean shouldIncludePendingCommits, boolean shouldValidateInstant, FileStatusCache fileStatusCache, boolean shouldListLazily, Option<String> beginInstantTime, Option<String> endInstantTime) {
        this.partitionColumns = metaClient.getTableConfig().getPartitionFields().orElse(new String[0]);
        this.metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(configProperties).enable(configProperties.getBoolean(HoodieMetadataConfig.ENABLE.key(), false) && HoodieTableMetadataUtil.isFilesPartitionAvailable(metaClient)).build();
        this.queryType = queryType;
        this.queryPaths = queryPaths;
        this.specifiedQueryInstant = specifiedQueryInstant;
        this.shouldIncludePendingCommits = shouldIncludePendingCommits;
        this.shouldValidateInstant = shouldValidateInstant;
        this.shouldListLazily = shouldListLazily;
        this.beginInstantTime = beginInstantTime;
        this.endInstantTime = endInstantTime;
        this.basePath = metaClient.getBasePathV2();
        this.metaClient = metaClient;
        this.engineContext = engineContext;
        this.fileStatusCache = fileStatusCache;
        this.doRefresh();
    }

    protected abstract Object[] doParsePartitionColumnValues(String[] var1, String var2);

    public Option<HoodieInstant> getLatestCompletedInstant() {
        return this.getActiveTimeline().filterCompletedInstants().lastInstant();
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public int getFileSlicesCount() {
        return this.getAllInputFileSlices().values().stream().mapToInt(List::size).sum();
    }

    @Override
    public void close() throws Exception {
        this.resetTableMetadata(null);
    }

    protected String[] getPartitionColumns() {
        return this.partitionColumns;
    }

    protected List<Path> getQueryPaths() {
        return this.queryPaths;
    }

    protected List<PartitionPath> getAllQueryPartitionPaths() {
        if (this.cachedAllPartitionPaths == null) {
            List<String> queryRelativePartitionPaths = this.queryPaths.stream().map(path -> FSUtils.getRelativePartitionPath(this.basePath, path)).collect(Collectors.toList());
            this.cachedAllPartitionPaths = this.listPartitionPaths(queryRelativePartitionPaths);
        }
        return this.cachedAllPartitionPaths;
    }

    protected Map<PartitionPath, List<FileSlice>> getAllInputFileSlices() {
        if (!this.areAllFileSlicesCached()) {
            this.ensurePreloadedPartitions(this.getAllQueryPartitionPaths());
        }
        return this.cachedAllInputFileSlices;
    }

    protected Map<PartitionPath, List<FileSlice>> getInputFileSlices(PartitionPath ... partitions) {
        this.ensurePreloadedPartitions(Arrays.asList(partitions));
        return Arrays.stream(partitions).collect(Collectors.toMap(Function.identity(), partition -> this.cachedAllInputFileSlices.get(partition)));
    }

    private void ensurePreloadedPartitions(List<PartitionPath> partitionPaths) {
        List<PartitionPath> missingPartitions = partitionPaths.stream().filter(p -> !this.cachedAllInputFileSlices.containsKey(p)).collect(Collectors.toList());
        this.cachedAllInputFileSlices.putAll(this.loadFileSlicesForPartitions(missingPartitions));
    }

    private Map<PartitionPath, List<FileSlice>> loadFileSlicesForPartitions(List<PartitionPath> partitions) {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.specifiedQueryInstant.isPresent() && !this.shouldIncludePendingCommits) {
            TimelineUtils.validateTimestampAsOf(this.metaClient, this.specifiedQueryInstant.get());
        }
        FileStatus[] allFiles = this.listPartitionPathFiles(partitions);
        HoodieTimeline activeTimeline = this.getActiveTimeline();
        Option<HoodieInstant> latestInstant = activeTimeline.lastInstant();
        HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(this.metaClient, activeTimeline, allFiles);
        Option<String> queryInstant = this.specifiedQueryInstant.or(() -> latestInstant.map(HoodieInstant::getTimestamp));
        this.validate(activeTimeline, queryInstant);
        return partitions.stream().collect(Collectors.toMap(Function.identity(), partitionPath -> queryInstant.map(instant -> fileSystemView.getLatestMergedFileSlicesBeforeOrOn(partitionPath.path, (String)queryInstant.get())).orElse(fileSystemView.getLatestFileSlices(partitionPath.path)).collect(Collectors.toList())));
    }

    protected List<PartitionPath> listPartitionPaths(List<String> relativePartitionPaths, Types.RecordType partitionFields, Expression partitionColumnPredicates) {
        List<String> matchedPartitionPaths;
        try {
            matchedPartitionPaths = this.tableMetadata.getPartitionPathWithPathPrefixUsingFilterExpression(relativePartitionPaths, partitionFields, partitionColumnPredicates);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error fetching partition paths", e);
        }
        return matchedPartitionPaths.stream().map(partitionPath -> {
            Object[] partitionColumnValues = this.parsePartitionColumnValues(this.partitionColumns, (String)partitionPath);
            return new PartitionPath((String)partitionPath, partitionColumnValues);
        }).collect(Collectors.toList());
    }

    protected List<PartitionPath> listPartitionPaths(List<String> relativePartitionPaths) {
        List<String> matchedPartitionPaths;
        try {
            if (this.isPartitionedTable()) {
                if (this.queryType == HoodieTableQueryType.INCREMENTAL && this.beginInstantTime.isPresent()) {
                    HoodieTimeline timelineAfterBeginInstant = TimelineUtils.getCommitsTimelineAfter(this.metaClient, this.beginInstantTime.get(), Option.empty());
                    HoodieTimeline timelineToQuery = this.endInstantTime.map(timelineAfterBeginInstant::findInstantsBeforeOrEquals).orElse(timelineAfterBeginInstant);
                    matchedPartitionPaths = TimelineUtils.getWrittenPartitions(timelineToQuery);
                } else {
                    matchedPartitionPaths = this.tableMetadata.getPartitionPathWithPathPrefixes(relativePartitionPaths);
                }
            } else {
                matchedPartitionPaths = Collections.singletonList("");
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error fetching partition paths", e);
        }
        return matchedPartitionPaths.stream().map(partitionPath -> {
            Object[] partitionColumnValues = this.parsePartitionColumnValues(this.partitionColumns, (String)partitionPath);
            return new PartitionPath((String)partitionPath, partitionColumnValues);
        }).collect(Collectors.toList());
    }

    protected void refresh() {
        this.fileStatusCache.invalidate();
        this.doRefresh();
    }

    private boolean isPartitionedTable() {
        return this.partitionColumns.length > 0 || HoodieTableMetadata.isMetadataTable(this.basePath.toString());
    }

    protected HoodieTimeline getActiveTimeline() {
        HoodieTimeline timeline = this.metaClient.getCommitsAndCompactionTimeline();
        if (this.shouldIncludePendingCommits) {
            return timeline;
        }
        return timeline.filterCompletedAndCompactionInstants();
    }

    private Object[] parsePartitionColumnValues(String[] partitionColumns, String partitionPath) {
        Object[] partitionColumnValues = this.doParsePartitionColumnValues(partitionColumns, partitionPath);
        if (this.shouldListLazily && partitionColumnValues.length != partitionColumns.length) {
            throw new HoodieException("Failed to parse partition column values from the partition-path: likely non-encoded slashes being used in partition column's values. You can try to work this around by switching listing mode to eager");
        }
        return partitionColumnValues;
    }

    private FileStatus[] listPartitionPathFiles(List<PartitionPath> partitions) {
        List partitionPaths = partitions.stream().map(partition -> CachingPath.createRelativePathUnsafe(partition.path)).collect(Collectors.toList());
        Map<Path, FileStatus[]> cachedPartitionPaths = partitionPaths.parallelStream().map(partitionPath -> Pair.of(partitionPath, this.fileStatusCache.get((Path)partitionPath))).filter(partitionPathFilesPair -> ((Option)partitionPathFilesPair.getRight()).isPresent()).collect(Collectors.toMap(Pair::getKey, p -> (FileStatus[])((Option)p.getRight()).get()));
        Set<Path> missingPartitionPaths = CollectionUtils.diffSet(partitionPaths, cachedPartitionPaths.keySet());
        Map missingPartitionPathsMap = missingPartitionPaths.stream().collect(Collectors.toMap(relativePartitionPath -> new CachingPath(this.basePath, (Path)relativePartitionPath).toString(), Function.identity()));
        try {
            Map<String, FileStatus[]> fetchedPartitionsMap = this.tableMetadata.getAllFilesInPartitions(missingPartitionPathsMap.keySet());
            fetchedPartitionsMap.forEach((absolutePath, files) -> {
                Path relativePath = (Path)missingPartitionPathsMap.get(absolutePath);
                this.fileStatusCache.put(relativePath, (FileStatus[])files);
            });
            return CollectionUtils.combine(BaseHoodieTableFileIndex.flatMap(cachedPartitionPaths.values()), BaseHoodieTableFileIndex.flatMap(fetchedPartitionsMap.values()));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to list partition paths", e);
        }
    }

    private void doRefresh() {
        HoodieTimer timer = HoodieTimer.start();
        this.resetTableMetadata(BaseHoodieTableFileIndex.createMetadataTable(this.engineContext, this.metadataConfig, this.basePath));
        this.metaClient.reloadActiveTimeline();
        this.cachedAllPartitionPaths = null;
        this.cachedAllInputFileSlices = new HashMap<PartitionPath, List<FileSlice>>();
        if (!this.shouldListLazily) {
            this.ensurePreloadedPartitions(this.getAllQueryPartitionPaths());
        }
        LOG.info(String.format("Refresh table %s, spent: %d ms", this.metaClient.getTableConfig().getTableName(), timer.endTimer()));
    }

    private void validate(HoodieTimeline activeTimeline, Option<String> queryInstant) {
        if (this.shouldValidateInstant && queryInstant.isPresent() && !activeTimeline.containsInstant(queryInstant.get())) {
            throw new HoodieIOException(String.format("Query instant (%s) not found in the timeline", queryInstant.get()));
        }
    }

    private boolean canParsePartitionValues() {
        return this.shouldListLazily || this.cachedAllPartitionPaths.stream().allMatch(p -> p.values.length > 0);
    }

    protected long getTotalCachedFilesSize() {
        return this.cachedAllInputFileSlices.values().stream().flatMap(Collection::stream).mapToLong(BaseHoodieTableFileIndex::fileSliceSize).sum();
    }

    protected boolean areAllFileSlicesCached() {
        return this.areAllPartitionPathsCached() && this.cachedAllPartitionPaths.stream().allMatch(p -> this.cachedAllInputFileSlices.containsKey(p));
    }

    protected boolean areAllPartitionPathsCached() {
        return this.cachedAllPartitionPaths != null;
    }

    protected boolean shouldReadAsPartitionedTable() {
        return this.partitionColumns.length > 0 && this.canParsePartitionValues() || HoodieTableMetadata.isMetadataTable(this.basePath.toString());
    }

    private static long fileSliceSize(FileSlice fileSlice) {
        long logFileSize = fileSlice.getLogFiles().map(HoodieLogFile::getFileSize).filter(s -> s > 0L).reduce(0L, Long::sum);
        return fileSlice.getBaseFile().map(BaseFile::getFileLen).orElse(0L) + logFileSize;
    }

    private void resetTableMetadata(HoodieTableMetadata newTableMetadata) {
        if (this.tableMetadata != null) {
            try {
                this.tableMetadata.close();
            }
            catch (Exception e) {
                throw new HoodieException("Failed to close HoodieTableMetadata instance", e);
            }
        }
        this.tableMetadata = newTableMetadata;
    }

    private static HoodieTableMetadata createMetadataTable(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, Path basePath) {
        HoodieTableMetadata newTableMetadata = HoodieTableMetadata.create(engineContext, metadataConfig, basePath.toString(), true);
        return newTableMetadata;
    }

    private static FileStatus[] flatMap(Collection<FileStatus[]> arrays) {
        return (FileStatus[])arrays.stream().flatMap(Arrays::stream).toArray(FileStatus[]::new);
    }

    protected static interface FileStatusCache {
        public Option<FileStatus[]> get(Path var1);

        public void put(Path var1, FileStatus[] var2);

        public void invalidate();
    }

    public static final class PartitionPath {
        final String path;
        final Object[] values;

        public PartitionPath(String path, Object[] values) {
            this.path = path;
            this.values = values;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object other) {
            return other instanceof PartitionPath && Objects.equals(this.path, ((PartitionPath)other).path) && Arrays.equals(this.values, ((PartitionPath)other).values);
        }

        public int hashCode() {
            return this.path.hashCode() * 1103 + Arrays.hashCode(this.values);
        }
    }
}

