/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.hadoop.CachingPath;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FilePathDTO {
    @JsonProperty(value="uri")
    private String uri;

    public static FilePathDTO fromPath(Path path) {
        if (null == path) {
            return null;
        }
        FilePathDTO dto = new FilePathDTO();
        dto.uri = path.toUri().toString();
        return dto;
    }

    public static Path toPath(FilePathDTO dto) {
        if (null == dto) {
            return null;
        }
        try {
            return new CachingPath(new URI(dto.uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

