/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Coprocessor {
    public static final int VERSION = 1;
    public static final int PRIORITY_HIGHEST = 0;
    public static final int PRIORITY_SYSTEM = 0x1FFFFFFF;
    public static final int PRIORITY_USER = 0x3FFFFFFF;
    public static final int PRIORITY_LOWEST = Integer.MAX_VALUE;

    default public void start(CoprocessorEnvironment env) throws IOException {
    }

    default public void stop(CoprocessorEnvironment env) throws IOException {
    }

    default public Iterable<Service> getServices() {
        return Collections.EMPTY_SET;
    }

    public static enum State {
        UNINSTALLED,
        INSTALLED,
        STARTING,
        ACTIVE,
        STOPPING,
        STOPPED;

    }
}

