/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.SortedCompactionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.util.DNS;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RatioBasedCompactionPolicy
extends SortedCompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RatioBasedCompactionPolicy.class);

    public RatioBasedCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<HStoreFile> filesToCompact) throws IOException {
        boolean result = false;
        long mcTime = this.getNextMajorCompactTime(filesToCompact);
        if (filesToCompact == null || filesToCompact.isEmpty() || mcTime == 0L) {
            return result;
        }
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = EnvironmentEdgeManager.currentTime();
        if (lowTimestamp > 0L && lowTimestamp < now - mcTime) {
            String regionInfo = this.storeConfigInfo != null && this.storeConfigInfo instanceof HStore ? ((HStore)this.storeConfigInfo).getRegionInfo().getRegionNameAsString() : this.toString();
            long cfTTL = Integer.MAX_VALUE;
            if (this.storeConfigInfo != null) {
                cfTTL = this.storeConfigInfo.getStoreFileTtl();
            }
            if (filesToCompact.size() == 1) {
                long oldest;
                HStoreFile sf = filesToCompact.iterator().next();
                OptionalLong minTimestamp = sf.getMinimumTimestamp();
                long l = oldest = minTimestamp.isPresent() ? now - minTimestamp.getAsLong() : Long.MIN_VALUE;
                if (sf.isMajorCompactionResult() && (cfTTL == Long.MAX_VALUE || oldest < cfTTL)) {
                    float blockLocalityIndex = sf.getHDFSBlockDistribution().getBlockLocalityIndex(DNS.getHostname(this.comConf.conf, DNS.ServerType.REGIONSERVER));
                    if (blockLocalityIndex < this.comConf.getMinLocalityToForceCompact()) {
                        LOG.debug("Major compaction triggered on only store " + regionInfo + "; to make hdfs blocks local, current blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")");
                        result = true;
                    } else {
                        LOG.debug("Skipping major compaction of " + regionInfo + " because one (major) compacted file only, oldestTime " + oldest + "ms is < TTL=" + cfTTL + " and blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")");
                    }
                } else if (cfTTL != Integer.MAX_VALUE && oldest > cfTTL) {
                    LOG.debug("Major compaction triggered on store " + regionInfo + ", because keyvalues outdated; time since last major compaction " + (now - lowTimestamp) + "ms");
                    result = true;
                }
            } else {
                LOG.debug("Major compaction triggered on store " + regionInfo + "; time since last major compaction " + (now - lowTimestamp) + "ms");
                result = true;
            }
        }
        return result;
    }

    @Override
    protected CompactionRequestImpl createCompactionRequest(ArrayList<HStoreFile> candidateSelection, boolean tryingMajor, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        if (!tryingMajor) {
            this.filterBulk(candidateSelection);
            candidateSelection = this.applyCompactionPolicy(candidateSelection, mayUseOffPeak, mayBeStuck);
            candidateSelection = this.checkMinFilesCriteria(candidateSelection, this.comConf.getMinFilesToCompact());
        }
        return new CompactionRequestImpl(candidateSelection);
    }

    protected ArrayList<HStoreFile> applyCompactionPolicy(ArrayList<HStoreFile> candidates, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        int filesToLeave;
        if (candidates.isEmpty()) {
            return candidates;
        }
        int start = 0;
        double ratio = this.comConf.getCompactionRatio();
        if (mayUseOffPeak) {
            ratio = this.comConf.getCompactionRatioOffPeak();
            LOG.info("Running an off-peak compaction, selection ratio = " + ratio);
        }
        int countOfFiles = candidates.size();
        long[] fileSizes = new long[countOfFiles];
        long[] sumSize = new long[countOfFiles];
        for (int i = countOfFiles - 1; i >= 0; --i) {
            HStoreFile file = candidates.get(i);
            fileSizes[i] = file.getReader().length();
            int tooFar = i + this.comConf.getMaxFilesToCompact() - 1;
            sumSize[i] = fileSizes[i] + (i + 1 < countOfFiles ? sumSize[i + 1] : 0L) - (tooFar < countOfFiles ? fileSizes[tooFar] : 0L);
        }
        while (countOfFiles - start >= this.comConf.getMinFilesToCompact() && fileSizes[start] > Math.max(this.comConf.getMinCompactSize(), (long)((double)sumSize[start + 1] * ratio))) {
            ++start;
        }
        if (start < countOfFiles) {
            LOG.info("Default compaction algorithm has selected " + (countOfFiles - start) + " files from " + countOfFiles + " candidates");
        } else if (mayBeStuck && (filesToLeave = candidates.size() - this.comConf.getMinFilesToCompact()) >= 0) {
            start = filesToLeave;
        }
        candidates.subList(0, start).clear();
        return candidates;
    }

    @Override
    public boolean needsCompaction(Collection<HStoreFile> storeFiles, List<HStoreFile> filesCompacting) {
        int numCandidates = storeFiles.size() - filesCompacting.size();
        return numCandidates >= this.comConf.getMinFilesToCompact();
    }

    public void setMinThreshold(int minThreshold) {
        this.comConf.setMinFilesToCompact(minThreshold);
    }
}

