/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.AuthUtil;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hudi.org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hudi.org.apache.hadoop.hbase.security.Superusers;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityControllerNotReadyException;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityScanDeleteTracker;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.MapMaker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class VisibilityController
implements MasterCoprocessor,
RegionCoprocessor,
VisibilityLabelsProtos.VisibilityLabelsService.Interface,
MasterObserver,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityController.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + VisibilityController.class.getName()));
    private boolean labelsRegion = false;
    private boolean accessControllerAvailable = false;
    private Configuration conf;
    private volatile boolean initialized = false;
    private boolean checkAuths = false;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private VisibilityLabelService visibilityLabelService;
    boolean authorizationEnabled;
    private static ArrayList<Byte> RESERVED_VIS_TAG_TYPES = new ArrayList();

    public static boolean isCellAuthorizationSupported(Configuration conf) {
        return AccessChecker.isAuthorizationSupported(conf);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        this.authorizationEnabled = AccessChecker.isAuthorizationSupported(this.conf);
        if (!this.authorizationEnabled) {
            LOG.warn("The VisibilityController has been loaded with authorization checks disabled.");
        }
        if (HFile.getFormatVersion(this.conf) < 3) {
            throw new RuntimeException("A minimum HFile version of 3 is required to persist visibility labels. Consider setting hfile.format.version accordingly.");
        }
        if (!(env instanceof MasterCoprocessorEnvironment)) {
            this.visibilityLabelService = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService(this.conf);
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    @Override
    public Iterable<Service> getServices() {
        return Collections.singleton(VisibilityLabelsProtos.VisibilityLabelsService.newReflectiveService(this));
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        try (Admin admin = ctx.getEnvironment().getConnection().getAdmin();){
            if (!admin.tableExists(VisibilityConstants.LABELS_TABLE_NAME)) {
                TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder(VisibilityConstants.LABELS_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(VisibilityConstants.LABELS_TABLE_FAMILY).setBloomFilterType(BloomType.NONE).setBlockCacheEnabled(false).build()).setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName()).build();
                admin.createTable(tableDescriptor);
            }
        }
    }

    @Override
    public TableDescriptor preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor currentDescriptor, TableDescriptor newDescriptor) throws IOException {
        if (this.authorizationEnabled && VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
        return newDescriptor;
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot disable " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (e.getEnvironment().getRegion().getRegionInfo().getTable().equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = true;
            VisibilityController visibilityController = this;
            synchronized (visibilityController) {
                this.accessControllerAvailable = CoprocessorHost.getLoadedCoprocessors().contains(AccessController.class.getName());
            }
            this.initVisibilityLabelService(e.getEnvironment());
        } else {
            this.checkAuths = e.getEnvironment().getConfiguration().getBoolean("hbase.security.visibility.mutations.checkauths", false);
            this.initVisibilityLabelService(e.getEnvironment());
        }
    }

    private void initVisibilityLabelService(RegionCoprocessorEnvironment env) {
        try {
            this.visibilityLabelService.init(env);
            this.initialized = true;
        }
        catch (IOException ioe) {
            LOG.error("Error while initializing VisibilityLabelService..", (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, MasterSwitchType switchType) throws IOException {
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (c.getEnvironment().getRegion().getRegionInfo().getTable().isSystemTable()) {
            return;
        }
        HashMap<String, List<Tag>> labelCache = new HashMap<String, List<Tag>>();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            CellVisibility cellVisibility = null;
            try {
                cellVisibility = m.getCellVisibility();
            }
            catch (DeserializationException de) {
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, de.getMessage()));
                continue;
            }
            boolean sanityFailure = false;
            boolean modifiedTagFound = false;
            Pair<Boolean, Object> pair = new Pair<Boolean, Object>(false, null);
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                pair = this.checkForReservedVisibilityTagPresence(cellScanner.current(), pair);
                if (!pair.getFirst().booleanValue()) {
                    if (!this.authorizationEnabled) break;
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, "Mutation contains cell with reserved type tag"));
                    sanityFailure = true;
                    break;
                }
                Tag tag = (Tag)pair.getSecond();
                if (cellVisibility != null || tag == null) continue;
                cellVisibility = new CellVisibility(Tag.getValueAsString(tag));
                modifiedTagFound = true;
            }
            if (sanityFailure || !(m instanceof Put) && !(m instanceof Delete) || cellVisibility == null) continue;
            String labelsExp = cellVisibility.getExpression();
            List<Tag> visibilityTags = (List<Tag>)labelCache.get(labelsExp);
            if (visibilityTags == null) {
                boolean authCheck = this.authorizationEnabled && this.checkAuths && !this.isSystemOrSuperUser();
                try {
                    visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, true, authCheck);
                }
                catch (InvalidLabelException e) {
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, e.getMessage()));
                }
                if (visibilityTags != null) {
                    labelCache.put(labelsExp, visibilityTags);
                }
            }
            if (visibilityTags == null) continue;
            ArrayList<Cell> updatedCells = new ArrayList<Cell>();
            CellScanner cellScanner2 = m.cellScanner();
            while (cellScanner2.advance()) {
                Cell cell = cellScanner2.current();
                List<Tag> tags = PrivateCellUtil.getTags(cell);
                if (modifiedTagFound) {
                    this.removeReplicationVisibilityTag(tags);
                }
                tags.addAll(visibilityTags);
                Cell updatedCell = PrivateCellUtil.createCell(cell, tags);
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                if (m instanceof Put) {
                    Put p = (Put)m;
                    p.add(cell);
                    continue;
                }
                Delete d = (Delete)m;
                d.add(cell);
            }
        }
    }

    @Override
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation delete, Cell cell, byte[] byteNow, Get get) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = delete.getCellVisibility();
        }
        catch (DeserializationException de) {
            throw new IOException("Invalid cell visibility specified " + delete, de);
        }
        List<Tag> visibilityTags = new ArrayList<Tag>();
        if (cellVisibility != null) {
            String labelsExp = cellVisibility.getExpression();
            try {
                visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, false, false);
            }
            catch (InvalidLabelException e) {
                throw new IOException("Invalid cell visibility specified " + labelsExp, e);
            }
        }
        get.setFilter(new DeleteVersionVisibilityExpressionFilter(visibilityTags, (byte)1));
        try (RegionScanner scanner = ctx.getEnvironment().getRegion().getScanner(new Scan(get));){
            ArrayList<Cell> result = new ArrayList<Cell>();
            scanner.next(result);
            if (result.size() < get.getMaxVersions()) {
                PrivateCellUtil.updateLatestStamp(cell, byteNow);
                return;
            }
            if (result.size() > get.getMaxVersions()) {
                throw new RuntimeException("Unexpected size: " + result.size() + ". Results more than the max versions obtained.");
            }
            Cell getCell = (Cell)result.get(get.getMaxVersions() - 1);
            PrivateCellUtil.setTimestamp(cell, getCell.getTimestamp());
        }
        ctx.bypass();
    }

    private Pair<Boolean, Tag> checkForReservedVisibilityTagPresence(Cell cell, Pair<Boolean, Tag> pair) throws IOException {
        if (pair == null) {
            pair = new Pair<Boolean, Object>(false, null);
        } else {
            pair.setFirst(false);
            pair.setSecond(null);
        }
        if (this.isSystemOrSuperUser()) {
            Tag modifiedTag = null;
            Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
            while (tagsIterator.hasNext()) {
                Tag tag = tagsIterator.next();
                if (tag.getType() != 7) continue;
                modifiedTag = tag;
                break;
            }
            pair.setFirst(true);
            pair.setSecond(modifiedTag);
            return pair;
        }
        Iterator<Tag> tagsItr = PrivateCellUtil.tagsIterator(cell);
        while (tagsItr.hasNext()) {
            if (!RESERVED_VIS_TAG_TYPES.contains(tagsItr.next().getType())) continue;
            return pair;
        }
        pair.setFirst(true);
        return pair;
    }

    private void removeReplicationVisibilityTag(List<Tag> tags) throws IOException {
        Iterator<Tag> iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag = iterator.next();
            if (tag.getType() != 7) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized!");
        }
        if (!this.authorizationEnabled) {
            return;
        }
        Region region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = scan.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            return;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(region, authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = scan.getFilter();
            if (filter != null) {
                scan.setFilter(new FilterList(filter, visibilityLabelFilter));
            } else {
                scan.setFilter(visibilityLabelFilter);
            }
        }
    }

    @Override
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        if (!this.authorizationEnabled) {
            return delTracker;
        }
        Region region = ctx.getEnvironment().getRegion();
        TableName table = region.getRegionInfo().getTable();
        if (table.isSystemTable()) {
            return delTracker;
        }
        return new VisibilityScanDeleteTracker(delTracker.getCellComparator());
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = VisibilityUtils.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    @Override
    @Deprecated
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, Cell curRowCell, boolean hasMore) throws IOException {
        return hasMore;
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (!RpcServer.isInRpcCallContext()) {
            return;
        }
        String requestUName = RpcServer.getRequestUserName().orElse(null);
        String owner = this.scannerOwners.get(s);
        if (this.authorizationEnabled && owner != null && !owner.equals(requestUName)) {
            throw new AccessDeniedException("User '" + requestUName + "' is not the scanner owner!");
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized");
        }
        if (!this.authorizationEnabled) {
            return;
        }
        Region region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = get.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            return;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(e.getEnvironment().getRegion(), authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = get.getFilter();
            if (filter != null) {
                get.setFilter(new FilterList(filter, visibilityLabelFilter));
            } else {
                get.setFilter(visibilityLabelFilter);
            }
        }
    }

    private boolean isSystemOrSuperUser() throws IOException {
        return Superusers.isSuperUser(VisibilityUtils.getActiveUser());
    }

    @Override
    public List<Pair<Cell, Cell>> postIncrementBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        ArrayList<Pair<Cell, Cell>> resultPairs = new ArrayList<Pair<Cell, Cell>>(cellPairs.size());
        for (Pair<Cell, Cell> pair : cellPairs) {
            resultPairs.add(new Pair<Cell, Cell>(pair.getFirst(), this.createNewCellWithTags(mutation, pair.getSecond())));
        }
        return resultPairs;
    }

    @Override
    public List<Pair<Cell, Cell>> postAppendBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        ArrayList<Pair<Cell, Cell>> resultPairs = new ArrayList<Pair<Cell, Cell>>(cellPairs.size());
        for (Pair<Cell, Cell> pair : cellPairs) {
            resultPairs.add(new Pair<Cell, Cell>(pair.getFirst(), this.createNewCellWithTags(mutation, pair.getSecond())));
        }
        return resultPairs;
    }

    private Cell createNewCellWithTags(Mutation mutation, Cell newCell) throws IOException {
        ArrayList<Tag> tags = Lists.newArrayList();
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = mutation.getCellVisibility();
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
        if (cellVisibility == null) {
            return newCell;
        }
        boolean authCheck = this.authorizationEnabled && this.checkAuths && !this.isSystemOrSuperUser();
        tags.addAll(this.visibilityLabelService.createVisibilityExpTags(cellVisibility.getExpression(), true, authCheck));
        Iterator<Tag> tagsItr = PrivateCellUtil.tagsIterator(newCell);
        while (tagsItr.hasNext()) {
            Tag tag = tagsItr.next();
            if (tag.getType() == 2 || tag.getType() == 4) continue;
            tags.add(tag);
        }
        return PrivateCellUtil.createCell(newCell, tags);
    }

    @Override
    public synchronized void addLabels(RpcController controller, VisibilityLabelsProtos.VisibilityLabelsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<VisibilityLabelsProtos.VisibilityLabel> visLabels = request.getVisLabelList();
        if (!this.initialized) {
            this.setExceptionResults(visLabels.size(), new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            ArrayList<byte[]> labels = new ArrayList<byte[]>(visLabels.size());
            try {
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (VisibilityLabelsProtos.VisibilityLabel visLabel : visLabels) {
                    byte[] label = visLabel.getLabel().toByteArray();
                    labels.add(label);
                    response.addResult(successResult);
                }
                if (!labels.isEmpty()) {
                    OperationStatus[] opStatus = this.visibilityLabelService.addLabels(labels);
                    this.logResult(true, "addLabels", "Adding labels allowed", null, labels, null);
                    int i = 0;
                    for (OperationStatus status : opStatus) {
                        while (!Objects.equals(response.getResult(i), successResult)) {
                            ++i;
                        }
                        if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                            ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                            failureResultBuilder.setException(VisibilityController.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                            response.setResult(i, failureResultBuilder.build());
                        }
                        ++i;
                    }
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "addLabels", e.getMessage(), null, labels, null);
                LOG.error("User is not having required permissions to add labels", (Throwable)e);
                this.setExceptionResults(visLabels.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
                this.setExceptionResults(visLabels.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    private void setExceptionResults(int size, IOException e, VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response) {
        ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        failureResultBuilder.setException(VisibilityController.buildException(e));
        ClientProtos.RegionActionResult failureResult = failureResultBuilder.build();
        for (int i = 0; i < size; ++i) {
            response.addResult(i, failureResult);
        }
    }

    @Override
    public synchronized void setAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<ByteString> auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            byte[] user = request.getUser().toByteArray();
            ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
            try {
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.setAuths(user, labelAuths);
                this.logResult(true, "setAuths", "Setting authorization for labels allowed", user, labelAuths, null);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(VisibilityController.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "setAuths", e.getMessage(), user, labelAuths, null);
                LOG.error("User is not having required permissions to set authorization", (Throwable)e);
                this.setExceptionResults(auths.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    private void logResult(boolean isAllowed, String request, String reason, byte[] user, List<byte[]> labelAuths, String regex) {
        if (AUDITLOG.isTraceEnabled()) {
            ArrayList<String> labelAuthsStr = new ArrayList<String>();
            if (labelAuths != null) {
                int labelAuthsSize = labelAuths.size();
                labelAuthsStr = new ArrayList(labelAuthsSize);
                for (int i = 0; i < labelAuthsSize; ++i) {
                    labelAuthsStr.add(Bytes.toString(labelAuths.get(i)));
                }
            }
            User requestingUser = null;
            try {
                requestingUser = VisibilityUtils.getActiveUser();
            }
            catch (IOException e) {
                LOG.warn("Failed to get active system user.");
                LOG.debug("Details on failure to get active system user.", (Throwable)e);
            }
            AUDITLOG.trace("Access " + (isAllowed ? "allowed" : "denied") + " for user " + (requestingUser != null ? requestingUser.getShortName() : "UNKNOWN") + "; reason: " + reason + "; remote address: " + RpcServer.getRemoteAddress().map(InetAddress::toString).orElse("") + "; request: " + request + "; user: " + (user != null ? Short.valueOf(Bytes.toShort(user)) : "null") + "; labels: " + labelAuthsStr + "; regex: " + regex);
        }
    }

    @Override
    public synchronized void getAuths(RpcController controller, VisibilityLabelsProtos.GetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.GetAuthsResponse> done) {
        VisibilityLabelsProtos.GetAuthsResponse.Builder response = VisibilityLabelsProtos.GetAuthsResponse.newBuilder();
        if (!this.initialized) {
            controller.setFailed("VisibilityController not yet initialized");
        } else {
            byte[] user = request.getUser().toByteArray();
            List<String> labels = null;
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User requestingUser = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (requestingUser != null ? requestingUser.getShortName() : "null") + "' is not authorized to perform this action.");
                }
                if (AuthUtil.isGroupPrincipal(Bytes.toString(user))) {
                    String group = AuthUtil.getGroupName(Bytes.toString(user));
                    labels = this.visibilityLabelService.getGroupAuths(new String[]{group}, false);
                } else {
                    labels = this.visibilityLabelService.getUserAuths(user, false);
                }
                this.logResult(true, "getAuths", "Get authorizations for user allowed", user, null, null);
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "getAuths", e.getMessage(), user, null, null);
                CoprocessorRpcUtils.setControllerException(controller, e);
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException(controller, e);
            }
            response.setUser(request.getUser());
            if (labels != null) {
                for (String label : labels) {
                    response.addAuth(ByteString.copyFrom((byte[])Bytes.toBytes(label)));
                }
            }
        }
        done.run((Object)response.build());
    }

    @Override
    public synchronized void clearAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<ByteString> auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), new CoprocessorException("VisibilityController not yet initialized"), response);
        } else {
            byte[] requestUser = request.getUser().toByteArray();
            ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User user = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + " is not authorized to perform this action.");
                }
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.clearAuths(requestUser, labelAuths);
                this.logResult(true, "clearAuths", "Removing authorization for labels allowed", requestUser, labelAuths, null);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(VisibilityController.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "clearAuths", e.getMessage(), requestUser, labelAuths, null);
                LOG.error("User is not having required permissions to clear authorization", (Throwable)e);
                this.setExceptionResults(auths.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    @Override
    public synchronized void listLabels(RpcController controller, VisibilityLabelsProtos.ListLabelsRequest request, RpcCallback<VisibilityLabelsProtos.ListLabelsResponse> done) {
        VisibilityLabelsProtos.ListLabelsResponse.Builder response = VisibilityLabelsProtos.ListLabelsResponse.newBuilder();
        if (!this.initialized) {
            controller.setFailed("VisibilityController not yet initialized");
        } else {
            List<String> labels = null;
            String regex = request.hasRegex() ? request.getRegex() : null;
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User requestingUser = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (requestingUser != null ? requestingUser.getShortName() : "null") + "' is not authorized to perform this action.");
                }
                labels = this.visibilityLabelService.listLabels(regex);
                this.logResult(true, "listLabels", "Listing labels allowed", null, null, regex);
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "listLabels", e.getMessage(), null, null, regex);
                CoprocessorRpcUtils.setControllerException(controller, e);
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException(controller, e);
            }
            if (labels != null && !labels.isEmpty()) {
                for (String label : labels) {
                    response.addLabel(ByteString.copyFrom((byte[])Bytes.toBytes(label)));
                }
            }
        }
        done.run((Object)response.build());
    }

    private void checkCallingUserAuth() throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (!this.accessControllerAvailable) {
            User user = VisibilityUtils.getActiveUser();
            if (user == null) {
                throw new IOException("Unable to retrieve calling user");
            }
            if (!this.visibilityLabelService.havingSystemAuth(user)) {
                throw new AccessDeniedException("User '" + user.getShortName() + "' is not authorized to perform this action.");
            }
        }
    }

    private static HBaseProtos.NameBytesPair buildException(Throwable t) {
        HBaseProtos.NameBytesPair.Builder parameterBuilder = HBaseProtos.NameBytesPair.newBuilder();
        parameterBuilder.setName(t.getClass().getName());
        parameterBuilder.setValue(ByteString.copyFromUtf8((String)StringUtils.stringifyException((Throwable)t)));
        return parameterBuilder.build();
    }

    static {
        RESERVED_VIS_TAG_TYPES.add((byte)2);
        RESERVED_VIS_TAG_TYPES.add((byte)4);
        RESERVED_VIS_TAG_TYPES.add((byte)7);
    }

    private static class DeleteVersionVisibilityExpressionFilter
    extends FilterBase {
        private List<Tag> deleteCellVisTags;
        private Byte deleteCellVisTagsFormat;

        public DeleteVersionVisibilityExpressionFilter(List<Tag> deleteCellVisTags, Byte deleteCellVisTagsFormat) {
            this.deleteCellVisTags = deleteCellVisTags;
            this.deleteCellVisTagsFormat = deleteCellVisTagsFormat;
        }

        @Override
        public boolean filterRowKey(Cell cell) throws IOException {
            return false;
        }

        @Override
        public Filter.ReturnCode filterCell(Cell cell) throws IOException {
            ArrayList<Tag> putVisTags = new ArrayList<Tag>();
            Byte putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
            if (putVisTags.isEmpty() && this.deleteCellVisTags.isEmpty()) {
                return Filter.ReturnCode.INCLUDE;
            }
            boolean matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, this.deleteCellVisTags, this.deleteCellVisTagsFormat);
            return matchFound ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteVersionVisibilityExpressionFilter)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            DeleteVersionVisibilityExpressionFilter f = (DeleteVersionVisibilityExpressionFilter)obj;
            return this.deleteCellVisTags.equals(f.deleteCellVisTags) && this.deleteCellVisTagsFormat.equals(f.deleteCellVisTagsFormat);
        }

        public int hashCode() {
            return Objects.hash(this.deleteCellVisTags, this.deleteCellVisTagsFormat);
        }
    }
}

