/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class CollectionUtils {
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public static Properties emptyProps() {
        return EMPTY_PROPERTIES;
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return Objects.isNull(c) || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return Objects.isNull(m) || m.isEmpty();
    }

    public static boolean nonEmpty(Collection<?> c) {
        return !CollectionUtils.isNullOrEmpty(c);
    }

    public static <T, U> U reduce(Collection<T> c, U identity, BiFunction<U, T, U> reducer) {
        return ((Stream)c.stream().sequential()).reduce(identity, reducer, (a, b) -> {
            throw new UnsupportedOperationException();
        });
    }

    public static Properties copy(Properties props) {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)props);
        return copy;
    }

    public static <T> T tail(T[] ts) {
        ValidationUtils.checkArgument(ts.length > 0);
        return ts[ts.length - 1];
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> T[] combine(T[] one, T[] another) {
        Object[] combined = (Object[])Array.newInstance(one.getClass().getComponentType(), one.length + another.length);
        System.arraycopy(one, 0, combined, 0, one.length);
        System.arraycopy(another, 0, combined, one.length, another.length);
        return combined;
    }

    public static <T> T[] append(T[] array, T elem) {
        Object[] combined = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, combined, 0, array.length);
        combined[array.length] = elem;
        return combined;
    }

    public static <E> List<E> combine(List<E> one, List<E> another) {
        ArrayList<E> combined = new ArrayList<E>(one.size() + another.size());
        combined.addAll(one);
        combined.addAll(another);
        return combined;
    }

    public static <K, V> HashMap<K, V> combine(Map<K, V> one, Map<K, V> another) {
        HashMap<K, V> combined = new HashMap<K, V>(one.size() + another.size());
        combined.putAll(one);
        combined.putAll(another);
        return combined;
    }

    public static <K, V> HashMap<K, V> combine(Map<K, V> one, Map<K, V> another, BiFunction<V, V, V> merge) {
        HashMap combined = new HashMap(one.size() + another.size());
        combined.putAll(one);
        another.forEach((k, v) -> combined.merge(k, v, merge));
        return combined;
    }

    public static <K, V> Map<K, V> zipToMap(List<K> keys, List<V> values) {
        ValidationUtils.checkArgument(keys.size() == values.size(), "keys' size must be equal with the values' size");
        return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, values::get));
    }

    public static <E> Set<E> diffSet(Collection<E> one, Set<E> another) {
        HashSet<E> diff = new HashSet<E>(one);
        diff.removeAll(another);
        return diff;
    }

    public static <E> List<E> diff(Collection<E> one, Collection<E> another) {
        ArrayList<E> diff = new ArrayList<E>(one);
        diff.removeAll(another);
        return diff;
    }

    public static <E> Stream<List<E>> batchesAsStream(List<E> list, int batchSize) {
        ValidationUtils.checkArgument(batchSize > 0, "batch size must be positive.");
        int total = list.size();
        if (total <= 0) {
            return Stream.empty();
        }
        int numFullBatches = (total - 1) / batchSize;
        return IntStream.range(0, numFullBatches + 1).mapToObj(n -> list.subList(n * batchSize, n == numFullBatches ? total : (n + 1) * batchSize));
    }

    public static <E> List<List<E>> batches(List<E> list, int batchSize) {
        return CollectionUtils.batchesAsStream(list, batchSize).collect(Collectors.toList());
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    @SafeVarargs
    public static <T> List<T> createImmutableList(T ... elements) {
        return Collections.unmodifiableList(Stream.of(elements).collect(Collectors.toList()));
    }

    public static <T> List<T> createImmutableList(List<T> list) {
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> createImmutableMap(Pair<K, V> ... elements) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : elements) {
            map.put(pair.getLeft(), pair.getRight());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> createImmutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <T> Set<T> createSet(T ... elements) {
        return Stream.of(elements).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Set<T> createImmutableSet(T ... elements) {
        return Collections.unmodifiableSet(CollectionUtils.createSet(elements));
    }

    public static <T> Set<T> createImmutableSet(Set<T> set) {
        return Collections.unmodifiableSet(set);
    }

    private static Object[] checkElementsNotNull(Object ... array) {
        return CollectionUtils.checkElementsNotNull(array, array.length);
    }

    private static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            CollectionUtils.checkElementNotNull(array[i], i);
        }
        return array;
    }

    private static Object checkElementNotNull(Object element, int index) {
        return Objects.requireNonNull(element, "Element is null at index " + index);
    }
}

