/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.PropertiesConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    public static final String STREAMER_CONFIG_PREFIX = "hoodie.streamer.";
    @Deprecated
    public static final String DELTA_STREAMER_CONFIG_PREFIX = "hoodie.deltastreamer.";
    public static final String SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.streamer.schemaprovider.";
    @Deprecated
    public static final String OLD_SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.deltastreamer.schemaprovider.";
    public static final String IS_QUERY_AS_RO_TABLE = "hoodie.query.as.ro.table";
    public static final String TABLE_SERDE_PATH = "path";
    public static final HoodieConfig DEFAULT_HUDI_CONFIG_FOR_READER = new HoodieConfig();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    public static String getOrderingField(Properties properties) {
        String orderField = null;
        if (properties.containsKey("hoodie.payload.ordering.field")) {
            orderField = properties.getProperty("hoodie.payload.ordering.field");
        } else if (properties.containsKey("hoodie.datasource.write.precombine.field")) {
            orderField = properties.getProperty("hoodie.datasource.write.precombine.field");
        } else if (properties.containsKey(HoodieTableConfig.PRECOMBINE_FIELD.key())) {
            orderField = properties.getProperty(HoodieTableConfig.PRECOMBINE_FIELD.key());
        }
        return orderField;
    }

    public static String getPayloadClass(Properties properties) {
        String payloadClass = null;
        if (properties.containsKey(HoodieTableConfig.PAYLOAD_CLASS_NAME.key())) {
            payloadClass = properties.getProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key());
        } else if (properties.containsKey("hoodie.datasource.write.payload.class")) {
            payloadClass = properties.getProperty("hoodie.datasource.write.payload.class");
        }
        return payloadClass;
    }

    public static List<String> split2List(String param) {
        return Arrays.stream(param.split(",")).map(String::trim).distinct().collect(Collectors.toList());
    }

    public static Map<String, String> toMap(String keyValueConfig) {
        return ConfigUtils.toMap(keyValueConfig, "\n");
    }

    public static Map<String, String> toMap(String keyValueConfig, String separator) {
        if (StringUtils.isNullOrEmpty(keyValueConfig)) {
            return new HashMap<String, String>();
        }
        String[] keyvalues = keyValueConfig.split(separator);
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        for (String keyValue : keyvalues) {
            if (keyValue.trim().isEmpty()) continue;
            String[] keyValueArray = keyValue.split("=");
            if (keyValueArray.length == 1 || keyValueArray.length == 2) {
                String key = keyValueArray[0].trim();
                String value = keyValueArray.length == 2 ? keyValueArray[1].trim() : "";
                tableProperties.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("Bad key-value config: " + keyValue + ", must be the format 'key = value'");
        }
        return tableProperties;
    }

    public static String configToString(Map<String, String> config) {
        if (config == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static <T extends Enum<T>> T resolveEnum(Class<T> enumType, String name) {
        Enum[] enumConstants;
        for (Enum constant : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(name)) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum constant found " + enumType.getName() + "." + name);
    }

    public static <T extends Enum<T>> String[] enumNames(Class<T> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        return (String[])Arrays.stream(enumConstants).map(Enum::name).toArray(String[]::new);
    }

    public static Option<String> stripPrefix(String prop, ConfigProperty<String> prefixConfig) {
        if (prop.startsWith(prefixConfig.key())) {
            return Option.of(String.join((CharSequence)"", prop.split(prefixConfig.key())));
        }
        for (String altPrefix : prefixConfig.getAlternatives()) {
            if (!prop.startsWith(altPrefix)) continue;
            return Option.of(String.join((CharSequence)"", prop.split(altPrefix)));
        }
        return Option.empty();
    }

    public static boolean containsConfigProperty(TypedProperties props, ConfigProperty<?> configProperty) {
        if (!props.containsKey(configProperty.key())) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!props.containsKey(alternative)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean containsConfigProperty(Map<String, Object> props, ConfigProperty<?> configProperty) {
        if (!props.containsKey(configProperty.key())) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!props.containsKey(alternative)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static void checkRequiredConfigProperties(TypedProperties props, List<ConfigProperty<?>> configPropertyList) {
        configPropertyList.forEach(configProperty -> {
            if (!ConfigUtils.containsConfigProperty(props, configProperty)) {
                throw new HoodieNotSupportedException("Required property " + configProperty.key() + " is missing");
            }
        });
    }

    public static Option<Object> getRawValueWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        if (props.containsKey(configProperty.key())) {
            return Option.ofNullable(props.get(configProperty.key()));
        }
        for (String alternative : configProperty.getAlternatives()) {
            if (!props.containsKey(alternative)) continue;
            LOG.warn(String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return Option.ofNullable(props.get(alternative));
        }
        return Option.empty();
    }

    public static String getStringWithAltKeys(TypedProperties props, ConfigProperty<String> configProperty) {
        return ConfigUtils.getStringWithAltKeys(props, configProperty, false);
    }

    public static String getStringWithAltKeys(TypedProperties props, ConfigProperty<String> configProperty, boolean useDefaultValue) {
        if (useDefaultValue) {
            return ConfigUtils.getStringWithAltKeys(props, configProperty, configProperty.hasDefaultValue() ? configProperty.defaultValue() : null);
        }
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        if (!rawValue.isPresent()) {
            throw new IllegalArgumentException("Property " + configProperty.key() + " not found");
        }
        return rawValue.get().toString();
    }

    public static String getStringWithAltKeys(TypedProperties props, ConfigProperty<?> configProperty, String defaultValue) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        return rawValue.map(Object::toString).orElse(defaultValue);
    }

    public static String getStringWithAltKeys(Map<String, Object> props, ConfigProperty<String> configProperty) {
        Object value = props.get(configProperty.key());
        if (value != null) {
            return value.toString();
        }
        for (String alternative : configProperty.getAlternatives()) {
            value = props.get(alternative);
            if (value == null) continue;
            LOG.warn(String.format("The configuration key '%s' has been deprecated and may be removed in the future. Please use the new key '%s' instead.", alternative, configProperty.key()));
            return value.toString();
        }
        return configProperty.hasDefaultValue() ? configProperty.defaultValue() : null;
    }

    public static String getStringWithAltKeys(TypedProperties props, String key, String altKey, String defaultValue) {
        if (props.containsKey(altKey)) {
            return props.getString(altKey);
        }
        if (props.containsKey(key)) {
            return props.getString(key);
        }
        return defaultValue;
    }

    public static boolean getBooleanWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        boolean defaultValue = configProperty.hasDefaultValue() ? Boolean.parseBoolean(configProperty.defaultValue().toString()) : false;
        return rawValue.map(v -> Boolean.parseBoolean(v.toString())).orElse(defaultValue);
    }

    public static int getIntWithAltKeys(TypedProperties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        int defaultValue = configProperty.hasDefaultValue() ? Integer.parseInt(configProperty.defaultValue().toString()) : 0;
        return rawValue.map(v -> Integer.parseInt(v.toString())).orElse(defaultValue);
    }

    public static long getLongWithAltKeys(TypedProperties props, ConfigProperty<Long> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        long defaultValue = configProperty.hasDefaultValue() ? configProperty.defaultValue() : 0L;
        return rawValue.map(v -> Long.parseLong(v.toString())).orElse(defaultValue);
    }

    public static void removeConfigFromProps(TypedProperties props, ConfigProperty<?> configProperty) {
        props.remove(configProperty.key());
        for (String alternative : configProperty.getAlternatives()) {
            props.remove(alternative);
        }
    }

    public static Map<String, Object> filterProperties(TypedProperties props, List<ConfigProperty<String>> configPropertyList) {
        Set<String> persistedKeys = ConfigUtils.getAllConfigKeys(configPropertyList);
        return props.entrySet().stream().filter(p -> persistedKeys.contains(String.valueOf(p.getKey()))).collect(Collectors.toMap((? super T e) -> String.valueOf(e.getKey()), (? super T e) -> String.valueOf(e.getValue())));
    }

    public static Set<String> getAllConfigKeys(List<ConfigProperty<String>> configPropertyList) {
        return configPropertyList.stream().flatMap(configProperty -> {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(configProperty.key());
            keys.addAll(configProperty.getAlternatives());
            return keys.stream();
        }).collect(Collectors.toSet());
    }

    public static HoodieConfig getReaderConfigs(StorageConfiguration<?> storageConf) {
        HoodieConfig config = new HoodieConfig();
        config.setAll(DEFAULT_HUDI_CONFIG_FOR_READER.getProps());
        config.setValue(HoodieReaderConfig.USE_NATIVE_HFILE_READER, Boolean.toString(storageConf.getBoolean(HoodieReaderConfig.USE_NATIVE_HFILE_READER.key(), HoodieReaderConfig.USE_NATIVE_HFILE_READER.defaultValue())));
        return config;
    }

    public static TypedProperties loadGlobalProperties() {
        return ((PropertiesConfig)ReflectionUtils.loadClass("org.apache.hudi.common.config.DFSPropertiesConfiguration")).getGlobalProperties();
    }
}

