/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Set;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.storage.HoodieBootstrapRecordIterator;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.org.apache.avro.Schema;

public abstract class HoodieBootstrapFileReader<T>
implements HoodieFileReader<T> {
    private final HoodieFileReader<T> skeletonFileReader;
    private final HoodieFileReader<T> dataFileReader;
    private final Option<String[]> partitionFields;
    private final Object[] partitionValues;

    public HoodieBootstrapFileReader(HoodieFileReader<T> skeletonFileReader, HoodieFileReader<T> dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        this.skeletonFileReader = skeletonFileReader;
        this.dataFileReader = dataFileReader;
        this.partitionFields = partitionFields;
        this.partitionValues = partitionValues;
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.skeletonFileReader.readMinMaxRecordKeys();
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.skeletonFileReader.readBloomFilter();
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.skeletonFileReader.filterRowKeys(candidateRowKeys);
    }

    @Override
    public ClosableIterator<HoodieRecord<T>> getRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        ClosableIterator<HoodieRecord<T>> skeletonIterator = this.skeletonFileReader.getRecordIterator(readerSchema, requestedSchema);
        ClosableIterator<HoodieRecord<T>> dataFileIterator = this.dataFileReader.getRecordIterator(HoodieAvroUtils.removeMetadataFields(readerSchema), requestedSchema);
        return new HoodieBootstrapRecordIterator<T>(skeletonIterator, dataFileIterator, readerSchema, this.partitionFields, this.partitionValues){

            @Override
            protected void setPartitionPathField(int position, Object fieldValue, T row) {
                HoodieBootstrapFileReader.this.setPartitionField(position, fieldValue, row);
            }
        };
    }

    @Override
    public ClosableIterator<HoodieRecord<T>> getRecordIterator(Schema schema) throws IOException {
        ClosableIterator<HoodieRecord<T>> skeletonIterator = this.skeletonFileReader.getRecordIterator(schema);
        ClosableIterator<HoodieRecord<T>> dataFileIterator = this.dataFileReader.getRecordIterator(this.dataFileReader.getSchema());
        return new HoodieBootstrapRecordIterator<T>(skeletonIterator, dataFileIterator, schema, this.partitionFields, this.partitionValues){

            @Override
            protected void setPartitionPathField(int position, Object fieldValue, T row) {
                HoodieBootstrapFileReader.this.setPartitionField(position, fieldValue, row);
            }
        };
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        final Schema schema = HoodieAvroUtils.getRecordKeySchema();
        final ClosableIterator<HoodieRecord<T>> skeletonIterator = this.skeletonFileReader.getRecordIterator(schema, schema);
        return new ClosableIterator<String>(){

            @Override
            public void close() {
                skeletonIterator.close();
            }

            @Override
            public boolean hasNext() {
                return skeletonIterator.hasNext();
            }

            @Override
            public String next() {
                HoodieRecord skeletonRecord = (HoodieRecord)skeletonIterator.next();
                return skeletonRecord.getRecordKey(schema, HoodieRecord.RECORD_KEY_METADATA_FIELD);
            }
        };
    }

    protected abstract void setPartitionField(int var1, Object var2, T var3);

    @Override
    public Schema getSchema() {
        return HoodieAvroUtils.addMetadataFields(this.dataFileReader.getSchema());
    }

    @Override
    public void close() {
        this.skeletonFileReader.close();
        this.dataFileReader.close();
    }

    @Override
    public long getTotalRecords() {
        return Math.min(this.skeletonFileReader.getTotalRecords(), this.dataFileReader.getTotalRecords());
    }
}

