/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Cell
extends HeapSize {
    public byte[] getRowArray();

    public int getRowOffset();

    public short getRowLength();

    public byte[] getFamilyArray();

    public int getFamilyOffset();

    public byte getFamilyLength();

    public byte[] getQualifierArray();

    public int getQualifierOffset();

    public int getQualifierLength();

    public long getTimestamp();

    @Deprecated
    public byte getTypeByte();

    @Deprecated
    public long getSequenceId();

    public byte[] getValueArray();

    public int getValueOffset();

    public int getValueLength();

    public int getSerializedSize();

    @Deprecated
    public byte[] getTagsArray();

    @Deprecated
    public int getTagsOffset();

    @Deprecated
    public int getTagsLength();

    default public Type getType() {
        byte byteType = this.getTypeByte();
        Type t = Type.CODE_ARRAY[byteType & 0xFF];
        if (t != null) {
            return t;
        }
        throw new UnsupportedOperationException("Invalid type of cell " + byteType);
    }

    public static enum Type {
        Put(4),
        Delete(8),
        DeleteFamilyVersion(10),
        DeleteColumn(12),
        DeleteFamily(14);

        private final byte code;
        private static final Type[] CODE_ARRAY;

        private Type(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        static {
            CODE_ARRAY = new Type[256];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type t;
                Type.CODE_ARRAY[t.code & 0xFF] = t = typeArray[i];
            }
        }
    }
}

