/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HadoopSeekableDataInputStream;
import org.apache.hudi.hadoop.fs.HoodieRetryWrapperFileSystem;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;

public class HoodieHadoopStorage
extends HoodieStorage {
    private final FileSystem fs;

    public HoodieHadoopStorage(StoragePath path, StorageConfiguration<?> conf) {
        super(conf);
        this.fs = HadoopFSUtils.getFs(path, conf.unwrapAs(Configuration.class));
    }

    public HoodieHadoopStorage(Path path, Configuration conf) {
        super(HadoopFSUtils.getStorageConf(conf));
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(String path, Configuration conf) {
        super(HadoopFSUtils.getStorageConf(conf));
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(String path, StorageConfiguration<?> conf) {
        super(conf);
        this.fs = HadoopFSUtils.getFs(path, conf);
    }

    public HoodieHadoopStorage(StoragePath path, StorageConfiguration<?> conf, boolean enableRetry, long maxRetryIntervalMs, int maxRetryNumbers, long initialRetryIntervalMs, String retryExceptions, ConsistencyGuard consistencyGuard) {
        super(conf);
        FileSystem fileSystem = HadoopFSUtils.getFs(path, conf.unwrapCopyAs(Configuration.class));
        if (enableRetry) {
            fileSystem = new HoodieRetryWrapperFileSystem(fileSystem, maxRetryIntervalMs, maxRetryNumbers, initialRetryIntervalMs, retryExceptions);
        }
        ValidationUtils.checkArgument(!(fileSystem instanceof HoodieWrapperFileSystem), "File System not expected to be that of HoodieWrapperFileSystem");
        this.fs = new HoodieWrapperFileSystem(fileSystem, consistencyGuard);
    }

    public HoodieHadoopStorage(FileSystem fs) {
        super(new HadoopStorageConfiguration(fs.getConf()));
        this.fs = fs;
    }

    @Override
    public HoodieStorage newInstance(StoragePath path, StorageConfiguration<?> storageConf) {
        return new HoodieHadoopStorage(path, storageConf);
    }

    @Override
    public String getScheme() {
        return this.fs.getScheme();
    }

    @Override
    public URI getUri() {
        return this.fs.getUri();
    }

    @Override
    public int getDefaultBlockSize(StoragePath path) {
        return (int)this.fs.getDefaultBlockSize(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public OutputStream create(StoragePath path, boolean overwrite) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path), overwrite);
    }

    @Override
    public OutputStream create(StoragePath path, boolean overwrite, Integer bufferSize, Short replication, Long sizeThreshold) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path), false, bufferSize.intValue(), replication.shortValue(), sizeThreshold.longValue(), null);
    }

    @Override
    public int getDefaultBufferSize() {
        return this.fs.getConf().getInt("io.file.buffer.size", 4096);
    }

    @Override
    public short getDefaultReplication(StoragePath path) {
        return this.fs.getDefaultReplication(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public InputStream open(StoragePath path) throws IOException {
        return this.fs.open(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public SeekableDataInputStream openSeekable(StoragePath path, int bufferSize, boolean wrapStream) throws IOException {
        return new HadoopSeekableDataInputStream(HadoopFSUtils.getFSDataInputStream(this.fs, path, bufferSize, wrapStream));
    }

    @Override
    public OutputStream append(StoragePath path) throws IOException {
        return this.fs.append(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public boolean exists(StoragePath path) throws IOException {
        return this.fs.exists(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public StoragePathInfo getPathInfo(StoragePath path) throws IOException {
        return HadoopFSUtils.convertToStoragePathInfo(this.fs.getFileStatus(HadoopFSUtils.convertToHadoopPath(path)));
    }

    @Override
    public boolean createDirectory(StoragePath path) throws IOException {
        return this.fs.mkdirs(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public List<StoragePathInfo> listDirectEntries(StoragePath path) throws IOException {
        return Arrays.stream(this.fs.listStatus(HadoopFSUtils.convertToHadoopPath(path))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    @Override
    public List<StoragePathInfo> listFiles(StoragePath path) throws IOException {
        ArrayList<StoragePathInfo> result = new ArrayList<StoragePathInfo>();
        RemoteIterator iterator = this.fs.listFiles(HadoopFSUtils.convertToHadoopPath(path), true);
        while (iterator.hasNext()) {
            result.add(HadoopFSUtils.convertToStoragePathInfo((FileStatus)iterator.next()));
        }
        return result;
    }

    @Override
    public List<StoragePathInfo> listDirectEntries(List<StoragePath> pathList) throws IOException {
        return Arrays.stream(this.fs.listStatus((Path[])pathList.stream().map(HadoopFSUtils::convertToHadoopPath).toArray(Path[]::new))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    @Override
    public List<StoragePathInfo> listDirectEntries(StoragePath path, StoragePathFilter filter) throws IOException {
        return Arrays.stream(this.fs.listStatus(HadoopFSUtils.convertToHadoopPath(path), e -> filter.accept(HadoopFSUtils.convertToStoragePath(e)))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    @Override
    public List<StoragePathInfo> globEntries(StoragePath pathPattern) throws IOException {
        return Arrays.stream(this.fs.globStatus(HadoopFSUtils.convertToHadoopPath(pathPattern))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    @Override
    public List<StoragePathInfo> globEntries(StoragePath pathPattern, StoragePathFilter filter) throws IOException {
        return Arrays.stream(this.fs.globStatus(HadoopFSUtils.convertToHadoopPath(pathPattern), path -> filter.accept(HadoopFSUtils.convertToStoragePath(path)))).map(HadoopFSUtils::convertToStoragePathInfo).collect(Collectors.toList());
    }

    @Override
    public boolean rename(StoragePath oldPath, StoragePath newPath) throws IOException {
        return this.fs.rename(HadoopFSUtils.convertToHadoopPath(oldPath), HadoopFSUtils.convertToHadoopPath(newPath));
    }

    @Override
    public boolean deleteDirectory(StoragePath path) throws IOException {
        return this.fs.delete(HadoopFSUtils.convertToHadoopPath(path), true);
    }

    @Override
    public boolean deleteFile(StoragePath path) throws IOException {
        return this.fs.delete(HadoopFSUtils.convertToHadoopPath(path), false);
    }

    @Override
    public Object getFileSystem() {
        return this.fs;
    }

    @Override
    public HoodieStorage getRawStorage() {
        if (this.fs instanceof HoodieWrapperFileSystem) {
            return new HoodieHadoopStorage(((HoodieWrapperFileSystem)this.fs).getFileSystem());
        }
        return this;
    }

    @Override
    public OutputStream create(StoragePath path) throws IOException {
        return this.fs.create(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public boolean createNewFile(StoragePath path) throws IOException {
        return this.fs.createNewFile(HadoopFSUtils.convertToHadoopPath(path));
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }
}

