/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hudi.exception.HoodieIndexException;

public class BloomFilter {
    public static final double LOG2_SQUARED = Math.log(2.0) * Math.log(2.0);
    private org.apache.hadoop.util.bloom.BloomFilter filter = null;

    public BloomFilter(int numEntries, double errorRate) {
        this(numEntries, errorRate, 1);
    }

    public BloomFilter(int numEntries, double errorRate, int hashType) {
        int bitSize = (int)Math.ceil((double)numEntries * (-Math.log(errorRate) / LOG2_SQUARED));
        int numHashs = (int)Math.ceil(Math.log(2.0) * (double)bitSize / (double)numEntries);
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter(bitSize, numHashs, hashType);
    }

    public BloomFilter(String filterStr) {
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter();
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)filterStr);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.filter.readFields((DataInput)dis);
            dis.close();
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter instance", e);
        }
    }

    public void add(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot by null");
        }
        this.filter.add(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean mightContain(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot by null");
        }
        return this.filter.membershipTest(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.filter.write((DataOutput)dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return DatatypeConverter.printBase64Binary((byte[])bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }
}

