/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;

public class HoodieCleanStat
implements Serializable {
    private final HoodieCleaningPolicy policy;
    private final String partitionPath;
    private final List<String> deletePathPatterns;
    private final List<String> successDeleteFiles;
    private final List<String> failedDeleteFiles;
    private final String earliestCommitToRetain;

    public HoodieCleanStat(HoodieCleaningPolicy policy, String partitionPath, List<String> deletePathPatterns, List<String> successDeleteFiles, List<String> failedDeleteFiles, String earliestCommitToRetain) {
        this.policy = policy;
        this.partitionPath = partitionPath;
        this.deletePathPatterns = deletePathPatterns;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.earliestCommitToRetain = earliestCommitToRetain;
    }

    public HoodieCleaningPolicy getPolicy() {
        return this.policy;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public List<String> getDeletePathPatterns() {
        return this.deletePathPatterns;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public String getEarliestCommitToRetain() {
        return this.earliestCommitToRetain;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HoodieCleaningPolicy policy;
        private List<String> deletePathPatterns;
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private String partitionPath;
        private String earliestCommitToRetain;

        public Builder withPolicy(HoodieCleaningPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder withDeletePathPattern(List<String> deletePathPatterns) {
            this.deletePathPatterns = deletePathPatterns;
            return this;
        }

        public Builder withSuccessfulDeletes(List<String> successDeleteFiles) {
            this.successDeleteFiles = successDeleteFiles;
            return this;
        }

        public Builder withFailedDeletes(List<String> failedDeleteFiles) {
            this.failedDeleteFiles = failedDeleteFiles;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder withEarliestCommitRetained(Option<HoodieInstant> earliestCommitToRetain) {
            this.earliestCommitToRetain = earliestCommitToRetain.isPresent() ? earliestCommitToRetain.get().getTimestamp() : "-1";
            return this;
        }

        public HoodieCleanStat build() {
            return new HoodieCleanStat(this.policy, this.partitionPath, this.deletePathPatterns, this.successDeleteFiles, this.failedDeleteFiles, this.earliestCommitToRetain);
        }
    }
}

