/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;

public class CompactionOperation
implements Serializable {
    private String baseInstantTime;
    private Option<String> dataFileCommitTime;
    private List<String> deltaFilePaths;
    private Option<String> dataFilePath;
    private HoodieFileGroupId id;
    private Map<String, Double> metrics;

    @Deprecated
    public CompactionOperation() {
    }

    public CompactionOperation(String fileId, String partitionPath, String baseInstantTime, Option<String> dataFileCommitTime, List<String> deltaFilePaths, Option<String> dataFilePath, Map<String, Double> metrics) {
        this.baseInstantTime = baseInstantTime;
        this.dataFileCommitTime = dataFileCommitTime;
        this.deltaFilePaths = deltaFilePaths;
        this.dataFilePath = dataFilePath;
        this.id = new HoodieFileGroupId(partitionPath, fileId);
        this.metrics = metrics;
    }

    public CompactionOperation(Option<HoodieDataFile> dataFile, String partitionPath, List<HoodieLogFile> logFiles, Map<String, Double> metrics) {
        if (dataFile.isPresent()) {
            this.baseInstantTime = dataFile.get().getCommitTime();
            this.dataFilePath = Option.of(dataFile.get().getPath());
            this.id = new HoodieFileGroupId(partitionPath, dataFile.get().getFileId());
            this.dataFileCommitTime = Option.of(dataFile.get().getCommitTime());
        } else {
            assert (logFiles.size() > 0);
            this.dataFilePath = Option.empty();
            this.baseInstantTime = FSUtils.getBaseCommitTimeFromLogPath(logFiles.get(0).getPath());
            this.id = new HoodieFileGroupId(partitionPath, FSUtils.getFileIdFromLogPath(logFiles.get(0).getPath()));
            this.dataFileCommitTime = Option.empty();
        }
        this.deltaFilePaths = logFiles.stream().map(s -> s.getPath().toString()).collect(Collectors.toList());
        this.metrics = metrics;
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public Option<String> getDataFileCommitTime() {
        return this.dataFileCommitTime;
    }

    public List<String> getDeltaFilePaths() {
        return this.deltaFilePaths;
    }

    public Option<String> getDataFilePath() {
        return this.dataFilePath;
    }

    public String getFileId() {
        return this.id.getFileId();
    }

    public String getPartitionPath() {
        return this.id.getPartitionPath();
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.id;
    }

    public Option<HoodieDataFile> getBaseFile() {
        return this.dataFilePath.map(df -> new HoodieDataFile((String)df));
    }

    public static CompactionOperation convertFromAvroRecordInstance(HoodieCompactionOperation operation) {
        CompactionOperation op = new CompactionOperation();
        op.baseInstantTime = operation.getBaseInstantTime();
        op.dataFilePath = Option.ofNullable(operation.getDataFilePath());
        op.dataFileCommitTime = op.dataFilePath.map(p -> FSUtils.getCommitTime(new Path(p).getName()));
        op.deltaFilePaths = new ArrayList<String>(operation.getDeltaFilePaths());
        op.id = new HoodieFileGroupId(operation.getPartitionPath(), operation.getFileId());
        op.metrics = operation.getMetrics() == null ? new HashMap<String, Double>() : new HashMap<String, Double>(operation.getMetrics());
        return op;
    }

    public String toString() {
        return "CompactionOperation{baseInstantTime='" + this.baseInstantTime + '\'' + ", dataFileCommitTime=" + this.dataFileCommitTime + ", deltaFilePaths=" + this.deltaFilePaths + ", dataFilePath=" + this.dataFilePath + ", id='" + this.id + '\'' + ", metrics=" + this.metrics + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionOperation operation = (CompactionOperation)o;
        return Objects.equals(this.baseInstantTime, operation.baseInstantTime) && Objects.equals(this.dataFileCommitTime, operation.dataFileCommitTime) && Objects.equals(this.deltaFilePaths, operation.deltaFilePaths) && Objects.equals(this.dataFilePath, operation.dataFilePath) && Objects.equals(this.id, operation.id);
    }

    public int hashCode() {
        return Objects.hash(this.baseInstantTime, this.id);
    }
}

