/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;

public class FileSlice
implements Serializable {
    private HoodieFileGroupId fileGroupId;
    private String baseInstantTime;
    private HoodieDataFile dataFile;
    private final TreeSet<HoodieLogFile> logFiles;

    public FileSlice(String partitionPath, String baseInstantTime, String fileId) {
        this(new HoodieFileGroupId(partitionPath, fileId), baseInstantTime);
    }

    public FileSlice(HoodieFileGroupId fileGroupId, String baseInstantTime) {
        this.fileGroupId = fileGroupId;
        this.baseInstantTime = baseInstantTime;
        this.dataFile = null;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
    }

    public void setDataFile(HoodieDataFile dataFile) {
        this.dataFile = dataFile;
    }

    public void addLogFile(HoodieLogFile logFile) {
        this.logFiles.add(logFile);
    }

    public Stream<HoodieLogFile> getLogFiles() {
        return this.logFiles.stream();
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public String getPartitionPath() {
        return this.fileGroupId.getPartitionPath();
    }

    public String getFileId() {
        return this.fileGroupId.getFileId();
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    public Option<HoodieDataFile> getDataFile() {
        return Option.ofNullable(this.dataFile);
    }

    public Option<HoodieLogFile> getLatestLogFile() {
        return Option.fromJavaOptional(this.logFiles.stream().findFirst());
    }

    public boolean isEmpty() {
        return this.dataFile == null && this.logFiles.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileSlice {");
        sb.append("fileGroupId=").append(this.fileGroupId);
        sb.append(", baseCommitTime=").append(this.baseInstantTime);
        sb.append(", dataFile='").append(this.dataFile).append('\'');
        sb.append(", logFiles='").append(this.logFiles).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSlice slice = (FileSlice)o;
        return Objects.equals(this.fileGroupId, slice.fileGroupId) && Objects.equals(this.baseInstantTime, slice.baseInstantTime) && Objects.equals(this.dataFile, slice.dataFile) && Objects.equals(this.logFiles, slice.logFiles);
    }

    public int hashCode() {
        return Objects.hash(this.fileGroupId, this.baseInstantTime);
    }
}

