/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;

public class HoodieFileGroup
implements Serializable {
    private final HoodieFileGroupId fileGroupId;
    private final TreeMap<String, FileSlice> fileSlices;
    private final HoodieTimeline timeline;
    private final Option<HoodieInstant> lastInstant;

    public static Comparator<String> getReverseCommitTimeComparator() {
        return Comparator.reverseOrder();
    }

    public HoodieFileGroup(String partitionPath, String id, HoodieTimeline timeline) {
        this(new HoodieFileGroupId(partitionPath, id), timeline);
    }

    public HoodieFileGroup(HoodieFileGroupId fileGroupId, HoodieTimeline timeline) {
        this.fileGroupId = fileGroupId;
        this.fileSlices = new TreeMap(HoodieFileGroup.getReverseCommitTimeComparator());
        this.timeline = timeline;
        this.lastInstant = timeline.lastInstant();
    }

    public void addNewFileSliceAtInstant(String baseInstantTime) {
        if (!this.fileSlices.containsKey(baseInstantTime)) {
            this.fileSlices.put(baseInstantTime, new FileSlice(this.fileGroupId, baseInstantTime));
        }
    }

    public void addDataFile(HoodieDataFile dataFile) {
        if (!this.fileSlices.containsKey(dataFile.getCommitTime())) {
            this.fileSlices.put(dataFile.getCommitTime(), new FileSlice(this.fileGroupId, dataFile.getCommitTime()));
        }
        this.fileSlices.get(dataFile.getCommitTime()).setDataFile(dataFile);
    }

    public void addLogFile(HoodieLogFile logFile) {
        if (!this.fileSlices.containsKey(logFile.getBaseCommitTime())) {
            this.fileSlices.put(logFile.getBaseCommitTime(), new FileSlice(this.fileGroupId, logFile.getBaseCommitTime()));
        }
        this.fileSlices.get(logFile.getBaseCommitTime()).addLogFile(logFile);
    }

    public String getPartitionPath() {
        return this.fileGroupId.getPartitionPath();
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    private boolean isFileSliceCommitted(FileSlice slice) {
        String maxCommitTime = this.lastInstant.get().getTimestamp();
        return this.timeline.containsOrBeforeTimelineStarts(slice.getBaseInstantTime()) && HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), maxCommitTime, HoodieTimeline.LESSER_OR_EQUAL);
    }

    public Stream<FileSlice> getAllFileSlicesIncludingInflight() {
        return this.fileSlices.entrySet().stream().map(Map.Entry::getValue);
    }

    public Option<FileSlice> getLatestFileSlicesIncludingInflight() {
        return Option.fromJavaOptional(this.getAllFileSlicesIncludingInflight().findFirst());
    }

    public Stream<FileSlice> getAllFileSlices() {
        if (!this.timeline.empty()) {
            return this.fileSlices.entrySet().stream().map(Map.Entry::getValue).filter(this::isFileSliceCommitted);
        }
        return Stream.empty();
    }

    public Option<FileSlice> getLatestFileSlice() {
        return Option.fromJavaOptional(this.getAllFileSlices().findFirst());
    }

    public Option<HoodieDataFile> getLatestDataFile() {
        return Option.fromJavaOptional(this.getAllDataFiles().findFirst());
    }

    public Option<FileSlice> getLatestFileSliceBeforeOrOn(String maxCommitTime) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), maxCommitTime, HoodieTimeline.LESSER_OR_EQUAL)).findFirst());
    }

    public Option<FileSlice> getLatestFileSliceBefore(String maxInstantTime) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> HoodieTimeline.compareTimestamps(slice.getBaseInstantTime(), maxInstantTime, HoodieTimeline.LESSER)).findFirst());
    }

    public Option<FileSlice> getLatestFileSliceInRange(List<String> commitRange) {
        return Option.fromJavaOptional(this.getAllFileSlices().filter(slice -> commitRange.contains(slice.getBaseInstantTime())).findFirst());
    }

    public Stream<HoodieDataFile> getAllDataFiles() {
        return this.getAllFileSlices().filter(slice -> slice.getDataFile().isPresent()).map(slice -> slice.getDataFile().get());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieFileGroup {");
        sb.append("id=").append(this.fileGroupId);
        sb.append(", fileSlices='").append(this.fileSlices).append('\'');
        sb.append(", lastInstant='").append(this.lastInstant).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void addFileSlice(FileSlice slice) {
        this.fileSlices.put(slice.getBaseInstantTime(), slice);
    }

    public Stream<FileSlice> getAllRawFileSlices() {
        return this.fileSlices.values().stream();
    }

    public HoodieTimeline getTimeline() {
        return this.timeline;
    }
}

