/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableConfig
implements Serializable {
    private static final transient Logger log = LogManager.getLogger(HoodieTableConfig.class);
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final String HOODIE_TABLE_NAME_PROP_NAME = "hoodie.table.name";
    public static final String HOODIE_TABLE_TYPE_PROP_NAME = "hoodie.table.type";
    public static final String HOODIE_RO_FILE_FORMAT_PROP_NAME = "hoodie.table.ro.file.format";
    public static final String HOODIE_RT_FILE_FORMAT_PROP_NAME = "hoodie.table.rt.file.format";
    public static final String HOODIE_PAYLOAD_CLASS_PROP_NAME = "hoodie.compaction.payload.class";
    public static final String HOODIE_ARCHIVELOG_FOLDER_PROP_NAME = "hoodie.archivelog.folder";
    public static final HoodieTableType DEFAULT_TABLE_TYPE = HoodieTableType.COPY_ON_WRITE;
    public static final HoodieFileFormat DEFAULT_RO_FILE_FORMAT = HoodieFileFormat.PARQUET;
    public static final HoodieFileFormat DEFAULT_RT_FILE_FORMAT = HoodieFileFormat.HOODIE_LOG;
    public static final String DEFAULT_PAYLOAD_CLASS = HoodieAvroPayload.class.getName();
    public static final String DEFAULT_ARCHIVELOG_FOLDER = "";
    private Properties props;

    public HoodieTableConfig(FileSystem fs, String metaPath) {
        Properties props = new Properties();
        Path propertyPath = new Path(metaPath, HOODIE_PROPERTIES_FILE);
        log.info((Object)("Loading dataset properties from " + propertyPath));
        try (FSDataInputStream inputStream = fs.open(propertyPath);){
            props.load((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load Hoodie properties from " + propertyPath, e);
        }
        this.props = props;
    }

    public HoodieTableConfig(Properties props) {
        this.props = props;
    }

    public HoodieTableConfig() {
    }

    public static void createHoodieProperties(FileSystem fs, Path metadataFolder, Properties properties) throws IOException {
        if (!fs.exists(metadataFolder)) {
            fs.mkdirs(metadataFolder);
        }
        Path propertyPath = new Path(metadataFolder, HOODIE_PROPERTIES_FILE);
        try (FSDataOutputStream outputStream = fs.create(propertyPath);){
            if (!properties.containsKey(HOODIE_TABLE_NAME_PROP_NAME)) {
                throw new IllegalArgumentException("hoodie.table.name property needs to be specified");
            }
            if (!properties.containsKey(HOODIE_TABLE_TYPE_PROP_NAME)) {
                properties.setProperty(HOODIE_TABLE_TYPE_PROP_NAME, DEFAULT_TABLE_TYPE.name());
            }
            if (properties.getProperty(HOODIE_TABLE_TYPE_PROP_NAME) == HoodieTableType.MERGE_ON_READ.name() && !properties.containsKey(HOODIE_PAYLOAD_CLASS_PROP_NAME)) {
                properties.setProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME, DEFAULT_PAYLOAD_CLASS);
            }
            if (!properties.containsKey(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME)) {
                properties.setProperty(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME, DEFAULT_ARCHIVELOG_FOLDER);
            }
            properties.store((OutputStream)outputStream, "Properties saved on " + new Date(System.currentTimeMillis()));
        }
    }

    public HoodieTableType getTableType() {
        if (this.props.containsKey(HOODIE_TABLE_TYPE_PROP_NAME)) {
            return HoodieTableType.valueOf(this.props.getProperty(HOODIE_TABLE_TYPE_PROP_NAME));
        }
        return DEFAULT_TABLE_TYPE;
    }

    public String getPayloadClass() {
        return this.props.getProperty(HOODIE_PAYLOAD_CLASS_PROP_NAME, DEFAULT_PAYLOAD_CLASS).replace("com.uber.hoodie", "org.apache.hudi");
    }

    public String getTableName() {
        return this.props.getProperty(HOODIE_TABLE_NAME_PROP_NAME);
    }

    public HoodieFileFormat getROFileFormat() {
        if (this.props.containsKey(HOODIE_RO_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_RO_FILE_FORMAT_PROP_NAME));
        }
        return DEFAULT_RO_FILE_FORMAT;
    }

    public HoodieFileFormat getRTFileFormat() {
        if (this.props.containsKey(HOODIE_RT_FILE_FORMAT_PROP_NAME)) {
            return HoodieFileFormat.valueOf(this.props.getProperty(HOODIE_RT_FILE_FORMAT_PROP_NAME));
        }
        return DEFAULT_RT_FILE_FORMAT;
    }

    public String getArchivelogFolder() {
        return this.props.getProperty(HOODIE_ARCHIVELOG_FOLDER_PROP_NAME, DEFAULT_ARCHIVELOG_FOLDER);
    }

    public Map<String, String> getProps() {
        return this.props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }
}

