/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.Serializable;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public interface HoodieTimeline
extends Serializable {
    public static final String COMMIT_ACTION = "commit";
    public static final String DELTA_COMMIT_ACTION = "deltacommit";
    public static final String CLEAN_ACTION = "clean";
    public static final String ROLLBACK_ACTION = "rollback";
    public static final String SAVEPOINT_ACTION = "savepoint";
    public static final String INFLIGHT_EXTENSION = ".inflight";
    public static final String COMPACTION_ACTION = "compaction";
    public static final String REQUESTED_EXTENSION = ".requested";
    public static final String RESTORE_ACTION = "restore";
    public static final String COMMIT_EXTENSION = ".commit";
    public static final String DELTA_COMMIT_EXTENSION = ".deltacommit";
    public static final String CLEAN_EXTENSION = ".clean";
    public static final String ROLLBACK_EXTENSION = ".rollback";
    public static final String SAVEPOINT_EXTENSION = ".savepoint";
    public static final String INFLIGHT_COMMIT_EXTENSION = ".inflight";
    public static final String INFLIGHT_DELTA_COMMIT_EXTENSION = ".deltacommit.inflight";
    public static final String INFLIGHT_CLEAN_EXTENSION = ".clean.inflight";
    public static final String INFLIGHT_ROLLBACK_EXTENSION = ".rollback.inflight";
    public static final String INFLIGHT_SAVEPOINT_EXTENSION = ".savepoint.inflight";
    public static final String REQUESTED_COMPACTION_SUFFIX = StringUtils.join("compaction", ".requested");
    public static final String REQUESTED_COMPACTION_EXTENSION = StringUtils.join(".", REQUESTED_COMPACTION_SUFFIX);
    public static final String INFLIGHT_COMPACTION_EXTENSION = StringUtils.join(".", "compaction", ".inflight");
    public static final String INFLIGHT_RESTORE_EXTENSION = ".restore.inflight";
    public static final String RESTORE_EXTENSION = ".restore";
    public static final String INVALID_INSTANT_TS = "0";
    public static final BiPredicate<String, String> EQUAL = (commit1, commit2) -> commit1.compareTo((String)commit2) == 0;
    public static final BiPredicate<String, String> GREATER_OR_EQUAL = (commit1, commit2) -> commit1.compareTo((String)commit2) >= 0;
    public static final BiPredicate<String, String> GREATER = (commit1, commit2) -> commit1.compareTo((String)commit2) > 0;
    public static final BiPredicate<String, String> LESSER_OR_EQUAL = (commit1, commit2) -> commit1.compareTo((String)commit2) <= 0;
    public static final BiPredicate<String, String> LESSER = (commit1, commit2) -> commit1.compareTo((String)commit2) < 0;

    public HoodieTimeline filterInflights();

    public HoodieTimeline filterInflightsExcludingCompaction();

    public HoodieTimeline filterCompletedInstants();

    public HoodieTimeline filterCompletedAndCompactionInstants();

    public HoodieTimeline getCommitsAndCompactionTimeline();

    public HoodieTimeline filterPendingCompactionTimeline();

    public HoodieTimeline findInstantsInRange(String var1, String var2);

    public HoodieTimeline findInstantsAfter(String var1, int var2);

    public HoodieTimeline filter(Predicate<HoodieInstant> var1);

    public boolean empty();

    public int countInstants();

    public Option<HoodieInstant> firstInstant();

    public Option<HoodieInstant> nthInstant(int var1);

    public Option<HoodieInstant> lastInstant();

    public String getTimelineHash();

    public Option<HoodieInstant> nthFromLastInstant(int var1);

    public boolean containsInstant(HoodieInstant var1);

    public boolean containsOrBeforeTimelineStarts(String var1);

    public Stream<HoodieInstant> getInstants();

    public Stream<HoodieInstant> getReverseOrderedInstants();

    public boolean isBeforeTimelineStarts(String var1);

    public Option<byte[]> getInstantDetails(HoodieInstant var1);

    public static boolean compareTimestamps(String commit1, String commit2, BiPredicate<String, String> predicateToApply) {
        return predicateToApply.test(commit1, commit2);
    }

    public static HoodieInstant getCompletedInstant(HoodieInstant instant) {
        return new HoodieInstant(false, instant.getAction(), instant.getTimestamp());
    }

    public static HoodieInstant getCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, COMPACTION_ACTION, timestamp);
    }

    public static HoodieInstant getCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, COMPACTION_ACTION, timestamp);
    }

    public static HoodieInstant getInflightInstant(HoodieInstant instant) {
        return new HoodieInstant(true, instant.getAction(), instant.getTimestamp());
    }

    public static String makeCommitFileName(String commitTime) {
        return StringUtils.join(commitTime, COMMIT_EXTENSION);
    }

    public static String makeInflightCommitFileName(String commitTime) {
        return StringUtils.join(commitTime, ".inflight");
    }

    public static String makeCleanerFileName(String instant) {
        return StringUtils.join(instant, CLEAN_EXTENSION);
    }

    public static String makeInflightCleanerFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_CLEAN_EXTENSION);
    }

    public static String makeRollbackFileName(String instant) {
        return StringUtils.join(instant, ROLLBACK_EXTENSION);
    }

    public static String makeInflightRollbackFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_ROLLBACK_EXTENSION);
    }

    public static String makeInflightSavePointFileName(String commitTime) {
        return StringUtils.join(commitTime, INFLIGHT_SAVEPOINT_EXTENSION);
    }

    public static String makeSavePointFileName(String commitTime) {
        return StringUtils.join(commitTime, SAVEPOINT_EXTENSION);
    }

    public static String makeInflightDeltaFileName(String commitTime) {
        return StringUtils.join(commitTime, INFLIGHT_DELTA_COMMIT_EXTENSION);
    }

    public static String makeInflightCompactionFileName(String commitTime) {
        return StringUtils.join(commitTime, INFLIGHT_COMPACTION_EXTENSION);
    }

    public static String makeRequestedCompactionFileName(String commitTime) {
        return StringUtils.join(commitTime, REQUESTED_COMPACTION_EXTENSION);
    }

    public static String makeRestoreFileName(String instant) {
        return StringUtils.join(instant, RESTORE_EXTENSION);
    }

    public static String makeInflightRestoreFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_RESTORE_EXTENSION);
    }

    public static String makeDeltaFileName(String commitTime) {
        return commitTime + DELTA_COMMIT_EXTENSION;
    }

    public static String getCommitFromCommitFile(String commitFileName) {
        return commitFileName.split("\\.")[0];
    }

    public static String makeFileNameAsComplete(String fileName) {
        return fileName.replace(".inflight", "");
    }

    public static String makeFileNameAsInflight(String fileName) {
        return StringUtils.join(fileName, ".inflight");
    }
}

