/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public interface TableFileSystemView {
    public Stream<HoodieFileGroup> getAllFileGroups(String var1);

    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations();

    public Option<HoodieInstant> getLastInstant();

    public HoodieTimeline getTimeline();

    public static interface RealtimeView
    extends RealtimeViewWithLatestSlice {
        public Stream<FileSlice> getAllFileSlices(String var1);
    }

    public static interface RealtimeViewWithLatestSlice {
        public Stream<FileSlice> getLatestFileSlices(String var1);

        public Option<FileSlice> getLatestFileSlice(String var1, String var2);

        public Stream<FileSlice> getLatestUnCompactedFileSlices(String var1);

        public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String var1, String var2, boolean var3);

        public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String var1, String var2);

        public Stream<FileSlice> getLatestFileSliceInRange(List<String> var1);
    }

    public static interface ReadOptimizedView
    extends ReadOptimizedViewWithLatestSlice {
        public Stream<HoodieDataFile> getAllDataFiles(String var1);

        public Option<HoodieDataFile> getDataFileOn(String var1, String var2, String var3);
    }

    public static interface ReadOptimizedViewWithLatestSlice {
        public Stream<HoodieDataFile> getLatestDataFiles(String var1);

        public Option<HoodieDataFile> getLatestDataFile(String var1, String var2);

        public Stream<HoodieDataFile> getLatestDataFiles();

        public Stream<HoodieDataFile> getLatestDataFilesBeforeOrOn(String var1, String var2);

        public Stream<HoodieDataFile> getLatestDataFilesInRange(List<String> var1);
    }
}

