/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordScanner;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMergedLogRecordScanner
extends AbstractHoodieLogRecordScanner
implements Iterable<HoodieRecord<? extends HoodieRecordPayload>> {
    private static final Logger log = LogManager.getLogger(HoodieMergedLogRecordScanner.class);
    private final ExternalSpillableMap<String, HoodieRecord<? extends HoodieRecordPayload>> records;
    private long numMergedRecordsInLog;
    private final long totalTimeTakenToReadAndMergeBlocks;
    public final HoodieTimer timer = new HoodieTimer();

    public HoodieMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, boolean readBlocksLazily, boolean reverseReader, int bufferSize, String spillableMapBasePath) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize);
        try {
            this.records = new ExternalSpillableMap(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(readerSchema));
            this.timer.startTimer();
            this.scan();
            this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
            this.numMergedRecordsInLog = this.records.size();
            log.info((Object)("MaxMemoryInBytes allowed for compaction => " + maxMemorySizeInBytes));
            log.info((Object)("Number of entries in MemoryBasedMap in ExternalSpillableMap => " + this.records.getInMemoryMapNumEntries()));
            log.info((Object)("Total size in bytes of MemoryBasedMap in ExternalSpillableMap => " + this.records.getCurrentInMemoryMapSize()));
            log.info((Object)("Number of entries in DiskBasedMap in ExternalSpillableMap => " + this.records.getDiskBasedMapNumEntries()));
            log.info((Object)("Size of file spilled to disk => " + this.records.getSizeOfFileOnDiskInBytes()));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when reading log file ");
        }
    }

    @Override
    public Iterator<HoodieRecord<? extends HoodieRecordPayload>> iterator() {
        return this.records.iterator();
    }

    public Map<String, HoodieRecord<? extends HoodieRecordPayload>> getRecords() {
        return this.records;
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        String key = hoodieRecord.getRecordKey();
        if (this.records.containsKey(key)) {
            Object combinedValue = hoodieRecord.getData().preCombine(((HoodieRecord)this.records.get(key)).getData());
            this.records.put(key, new HoodieRecord(new HoodieKey(key, hoodieRecord.getPartitionPath()), combinedValue));
        } else {
            this.records.put(key, hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        this.records.put(hoodieKey.getRecordKey(), (HoodieRecord<? extends HoodieRecordPayload>)((Serializable)SpillableMapUtils.generateEmptyPayload(hoodieKey.getRecordKey(), hoodieKey.getPartitionPath(), this.getPayloadClassFQN())));
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }
}

