/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.util.FSUtils;

public class HoodieInstant
implements Serializable {
    private State state = State.COMPLETED;
    private String action;
    private String timestamp;

    public HoodieInstant(FileStatus fileStatus) {
        String fileName = fileStatus.getPath().getName();
        String fileExtension = FSUtils.getFileExtension(fileName);
        this.timestamp = fileName.replace(fileExtension, "");
        this.action = fileExtension.replaceFirst(".", "");
        if (this.action.equals("inflight")) {
            this.action = "commit";
            this.state = State.INFLIGHT;
        } else if (this.action.contains(".inflight")) {
            this.state = State.INFLIGHT;
            this.action = this.action.replace(".inflight", "");
        } else if (this.action.equals(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX)) {
            this.state = State.REQUESTED;
            this.action = this.action.replace(".requested", "");
        }
    }

    public HoodieInstant(boolean isInflight, String action, String timestamp) {
        this.state = isInflight ? State.INFLIGHT : State.COMPLETED;
        this.action = action;
        this.timestamp = timestamp;
    }

    public HoodieInstant(State state, String action, String timestamp) {
        this.state = state;
        this.action = action;
        this.timestamp = timestamp;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isInflight() {
        return this.state == State.INFLIGHT;
    }

    public boolean isRequested() {
        return this.state == State.REQUESTED;
    }

    public String getAction() {
        return this.action;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFileName() {
        if ("commit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCommitFileName(this.timestamp) : HoodieTimeline.makeCommitFileName(this.timestamp);
        }
        if ("clean".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCleanerFileName(this.timestamp) : HoodieTimeline.makeCleanerFileName(this.timestamp);
        }
        if ("rollback".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRollbackFileName(this.timestamp) : HoodieTimeline.makeRollbackFileName(this.timestamp);
        }
        if ("savepoint".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightSavePointFileName(this.timestamp) : HoodieTimeline.makeSavePointFileName(this.timestamp);
        }
        if ("deltacommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightDeltaFileName(this.timestamp) : HoodieTimeline.makeDeltaFileName(this.timestamp);
        }
        if ("compaction".equals(this.action)) {
            if (this.isInflight()) {
                return HoodieTimeline.makeInflightCompactionFileName(this.timestamp);
            }
            if (this.isRequested()) {
                return HoodieTimeline.makeRequestedCompactionFileName(this.timestamp);
            }
            return HoodieTimeline.makeCommitFileName(this.timestamp);
        }
        if ("restore".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRestoreFileName(this.timestamp) : HoodieTimeline.makeRestoreFileName(this.timestamp);
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + this.action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieInstant that = (HoodieInstant)o;
        return this.state == that.state && Objects.equals(this.action, that.action) && Objects.equals(this.timestamp, that.timestamp);
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.action, this.timestamp});
    }

    public String toString() {
        return "[" + (this.isInflight() || this.isRequested() ? "==>" : "") + this.timestamp + "__" + this.action + "__" + (Object)((Object)this.state) + "]";
    }

    public static enum State {
        REQUESTED,
        INFLIGHT,
        COMPLETED,
        INVALID;

    }
}

