/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.table.timeline.dto.FileStatusDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataFileDTO {
    @JsonProperty(value="fileStatus")
    private FileStatusDTO fileStatus;
    @JsonProperty(value="fullPath")
    private String fullPath;
    @JsonProperty(value="fileLen")
    private long fileLen;

    public static HoodieDataFile toHoodieDataFile(DataFileDTO dto) {
        if (null == dto) {
            return null;
        }
        HoodieDataFile dataFile = null;
        if (null != dto.fileStatus) {
            dataFile = new HoodieDataFile(FileStatusDTO.toFileStatus(dto.fileStatus));
        } else {
            dataFile = new HoodieDataFile(dto.fullPath);
            dataFile.setFileLen(dto.fileLen);
        }
        return dataFile;
    }

    public static DataFileDTO fromHoodieDataFile(HoodieDataFile dataFile) {
        if (null == dataFile) {
            return null;
        }
        DataFileDTO dto = new DataFileDTO();
        dto.fileStatus = FileStatusDTO.fromFileStatus(dataFile.getFileStatus());
        dto.fullPath = dataFile.getPath();
        dto.fileLen = dataFile.getFileLen();
        return dto;
    }
}

