/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.table.timeline.dto.FSPermissionDTO;
import org.apache.hudi.common.table.timeline.dto.FilePathDTO;
import org.apache.hudi.exception.HoodieException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileStatusDTO {
    @JsonProperty(value="path")
    FilePathDTO path;
    @JsonProperty(value="length")
    long length;
    @JsonProperty(value="isdir")
    boolean isdir;
    @JsonProperty(value="blockReplication")
    short blockReplication;
    @JsonProperty(value="blocksize")
    long blocksize;
    @JsonProperty(value="modificationTime")
    long modificationTime;
    @JsonProperty(value="accessTime")
    long accessTime;
    @JsonProperty(value="permission")
    FSPermissionDTO permission;
    @JsonProperty(value="owner")
    String owner;
    @JsonProperty(value="group")
    String group;
    @JsonProperty(value="symlink")
    FilePathDTO symlink;

    public static FileStatusDTO fromFileStatus(FileStatus fileStatus) {
        if (null == fileStatus) {
            return null;
        }
        FileStatusDTO dto = new FileStatusDTO();
        try {
            dto.path = FilePathDTO.fromPath(fileStatus.getPath());
            dto.length = fileStatus.getLen();
            dto.isdir = fileStatus.isDirectory();
            dto.blockReplication = fileStatus.getReplication();
            dto.blocksize = fileStatus.getBlockSize();
            dto.modificationTime = fileStatus.getModificationTime();
            dto.accessTime = fileStatus.getModificationTime();
            dto.symlink = fileStatus.isSymlink() ? FilePathDTO.fromPath(fileStatus.getSymlink()) : null;
            FileStatusDTO.safeReadAndSetMetadata(dto, fileStatus);
        }
        catch (IOException ioe) {
            throw new HoodieException(ioe);
        }
        return dto;
    }

    private static void safeReadAndSetMetadata(FileStatusDTO dto, FileStatus fileStatus) {
        try {
            dto.owner = fileStatus.getOwner();
            dto.group = fileStatus.getGroup();
            dto.permission = FSPermissionDTO.fromFsPermission(fileStatus.getPermission());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static FileStatus toFileStatus(FileStatusDTO dto) {
        if (null == dto) {
            return null;
        }
        return new FileStatus(dto.length, dto.isdir, (int)dto.blockReplication, dto.blocksize, dto.modificationTime, dto.accessTime, FSPermissionDTO.fromFsPermissionDTO(dto.permission), dto.owner, dto.group, FilePathDTO.toPath(dto.symlink), FilePathDTO.toPath(dto.path));
    }
}

