/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.SyncableFileSystemView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PriorityBasedFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static Logger log = LogManager.getLogger(PriorityBasedFileSystemView.class);
    private final SyncableFileSystemView preferredView;
    private final SyncableFileSystemView secondaryView;
    private boolean errorOnPreferredView;

    public PriorityBasedFileSystemView(SyncableFileSystemView preferredView, SyncableFileSystemView secondaryView) {
        this.preferredView = preferredView;
        this.secondaryView = secondaryView;
        this.errorOnPreferredView = false;
    }

    private <R> R execute(Functions.Function0<R> preferredFunction, Functions.Function0<R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            log.warn((Object)"Routing request to secondary file-system view");
            return secondaryFunction.apply();
        }
        try {
            return preferredFunction.apply();
        }
        catch (RuntimeException re) {
            log.error((Object)"Got error running preferred function. Trying secondary", (Throwable)re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply();
        }
    }

    private <T1, R> R execute(T1 val, Functions.Function1<T1, R> preferredFunction, Functions.Function1<T1, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            log.warn((Object)"Routing request to secondary file-system view");
            return secondaryFunction.apply(val);
        }
        try {
            return preferredFunction.apply(val);
        }
        catch (RuntimeException re) {
            log.error((Object)"Got error running preferred function. Trying secondary", (Throwable)re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val);
        }
    }

    private <T1, T2, R> R execute(T1 val, T2 val2, Functions.Function2<T1, T2, R> preferredFunction, Functions.Function2<T1, T2, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            log.warn((Object)"Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2);
        }
        try {
            return preferredFunction.apply(val, val2);
        }
        catch (RuntimeException re) {
            log.error((Object)"Got error running preferred function. Trying secondary", (Throwable)re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2);
        }
    }

    private <T1, T2, T3, R> R execute(T1 val, T2 val2, T3 val3, Functions.Function3<T1, T2, T3, R> preferredFunction, Functions.Function3<T1, T2, T3, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            log.warn((Object)"Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2, val3);
        }
        try {
            return preferredFunction.apply(val, val2, val3);
        }
        catch (RuntimeException re) {
            log.error((Object)"Got error running preferred function. Trying secondary", (Throwable)re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2, val3);
        }
    }

    @Override
    public Stream<HoodieDataFile> getLatestDataFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestDataFiles, this.secondaryView::getLatestDataFiles);
    }

    @Override
    public Stream<HoodieDataFile> getLatestDataFiles() {
        return this.execute(this.preferredView::getLatestDataFiles, this.secondaryView::getLatestDataFiles);
    }

    @Override
    public Stream<HoodieDataFile> getLatestDataFilesBeforeOrOn(String partitionPath, String maxCommitTime) {
        return this.execute(partitionPath, maxCommitTime, this.preferredView::getLatestDataFilesBeforeOrOn, this.secondaryView::getLatestDataFilesBeforeOrOn);
    }

    @Override
    public Option<HoodieDataFile> getLatestDataFile(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestDataFile, this.secondaryView::getLatestDataFile);
    }

    @Override
    public Option<HoodieDataFile> getDataFileOn(String partitionPath, String instantTime, String fileId) {
        return this.execute(partitionPath, instantTime, fileId, this.preferredView::getDataFileOn, this.secondaryView::getDataFileOn);
    }

    @Override
    public Stream<HoodieDataFile> getLatestDataFilesInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestDataFilesInRange, this.secondaryView::getLatestDataFilesInRange);
    }

    @Override
    public Stream<HoodieDataFile> getAllDataFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllDataFiles, this.secondaryView::getAllDataFiles);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlices, this.secondaryView::getLatestFileSlices);
    }

    @Override
    public Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestUnCompactedFileSlices, this.secondaryView::getLatestUnCompactedFileSlices);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        return this.execute(partitionPath, maxCommitTime, includeFileSlicesInPendingCompaction, this.preferredView::getLatestFileSlicesBeforeOrOn, this.secondaryView::getLatestFileSlicesBeforeOrOn);
    }

    @Override
    public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionPath, String maxInstantTime) {
        return this.execute(partitionPath, maxInstantTime, this.preferredView::getLatestMergedFileSlicesBeforeOrOn, this.secondaryView::getLatestMergedFileSlicesBeforeOrOn);
    }

    @Override
    public Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestFileSliceInRange, this.secondaryView::getLatestFileSliceInRange);
    }

    @Override
    public Stream<FileSlice> getAllFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileSlices, this.secondaryView::getAllFileSlices);
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileGroups, this.secondaryView::getAllFileGroups);
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        return this.execute(this.preferredView::getPendingCompactionOperations, this.secondaryView::getPendingCompactionOperations);
    }

    @Override
    public void close() {
        this.preferredView.close();
        this.secondaryView.close();
    }

    @Override
    public void reset() {
        this.preferredView.reset();
        this.secondaryView.reset();
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.execute(this.preferredView::getLastInstant, this.secondaryView::getLastInstant);
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.execute(this.preferredView::getTimeline, this.secondaryView::getTimeline);
    }

    @Override
    public void sync() {
        this.preferredView.reset();
        this.secondaryView.reset();
    }

    @Override
    public Option<FileSlice> getLatestFileSlice(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestFileSlice, this.secondaryView::getLatestFileSlice);
    }

    public SyncableFileSystemView getPreferredView() {
        return this.preferredView;
    }

    public SyncableFileSystemView getSecondaryView() {
        return this.secondaryView;
    }
}

